/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.appslibrary;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.transport.SingleResourceTransportDto;

/**
 * Used to create a new virtual machine template. To create a persistent virtual machine template
 * use {@link VirtualMachineTemplatePersistentDto}.
 * <ul>
 * <li>DOWNLOAD Task: use a template definition link</li>
 * <li>PROMOTE Task: use a virtual machine template link (it should be an instance)</li>
 * </ul>
 * 
 * @restlink <link rel="templateDefinition" href=
 *           "http://example.com/admin/enterprises/{enterpriseId}/appslib/templateDefinitions/{templateDefinitionId}"
 *           title="" />
 * @restlink <link rel="virtualmachinetemplate" href=
 *           "http://example.com/admin/enterprises/{enterpriseId}/datacenterrepositories/{datacenterId}/virtualmachinetemplates/{virtualmachinetemplateId}"
 *           title="" />
 */
@XmlRootElement(name = "virtualmachinetemplaterequest")
@XmlType(propOrder = {"promotedName"})
public class VirtualMachineTemplateRequestDto extends SingleResourceTransportDto implements
    Serializable
{
    private static final long serialVersionUID = 7388236004519623022L;

    private static final String TYPE = "application/vnd.abiquo.virtualmachinetemplaterequest";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    private String promotedName;

    /**
     * Name for the new promoted virtual machine template
     * <p>
     * Only required for PROMOTE Task : Virtual machine template instance link present
     */
    public String getPromotedName()
    {
        return promotedName;
    }

    public void setPromotedName(final String promotedName)
    {
        this.promotedName = promotedName;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }
}
