/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.cloud;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.transport.SingleResourceTransportDto;

@XmlRootElement(name = "firewallrule")
@XmlType(propOrder = {"id", "protocol", "fromPort", "toPort", "targets", "sources"})
public class FirewallRuleDto extends SingleResourceTransportDto
{
    private static final long serialVersionUID = 6452535360028092851L;

    private static final String TYPE = "application/vnd.abiquo.firewallrule";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    private Integer id;

    public Integer getId()
    {
        return id;
    }

    public void setId(final Integer id)
    {
        this.id = id;
    }

    private String protocol;

    public String getProtocol()
    {
        return protocol;
    }

    public void setProtocol(final String protocol)
    {
        this.protocol = protocol;
    }

    private Integer fromPort;

    public Integer getFromPort()
    {
        return fromPort;
    }

    public void setFromPort(final Integer fromPort)
    {
        this.fromPort = fromPort;
    }

    private Integer toPort;

    public Integer getToPort()
    {
        return toPort;
    }

    public void setToPort(final Integer toPort)
    {
        this.toPort = toPort;
    }

    // egress
    private List<String> targets;

    @XmlElement(name = "target")
    public List<String> getTargets()
    {
        if (targets == null)
        {
            targets = new ArrayList<String>();
        }
        return targets;
    }

    public void setTargets(final List<String> targets)
    {
        this.targets = targets;
    }

    // ingress
    private List<String> sources;

    @XmlElement(name = "source")
    public List<String> getSources()
    {
        if (sources == null)
        {
            sources = new ArrayList<String>();
        }
        return sources;
    }

    public void setSources(final List<String> sources)
    {
        this.sources = sources;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }
}
