/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.cloud;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.transport.SingleResourceTransportDto;

/**
 * Define how to know if a certain virtual machine is suitable to accept traffic from the
 * {@link LoadBalancerDto}.
 */
@XmlRootElement(name = "healthcheck")
@XmlType(propOrder = {"name", "path", "protocol", "port", "providerId", "intervalInMs",
"timeoutInMs", "attempts", "statusRegex", "bodyRegex"})
public class HealthCheckDto extends SingleResourceTransportDto implements Serializable
{
    private static final long serialVersionUID = -303542311985087723L;

    /** The Constant BASE_MEDIA_TYPE. */
    private static final String TYPE = "application/vnd.abiquo.healthcheck";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    private String name;

    private String path;

    private String protocol;

    private int port;

    private String providerId;

    private long intervalInMs;

    private long timeoutInMs;

    private int attempts;

    private String statusRegex;

    private String bodyRegex;

    /**
     * Friendly name. Required
     */
    public String getName()
    {
        return name;
    }

    public void setName(final String name)
    {
        this.name = name;
    }

    /**
     * Additional info in perform the check. Optional. (example 'webapp/index.html').
     */
    public String getPath()
    {
        return path;
    }

    public void setPath(final String path)
    {
        this.path = path;
    }

    /**
     * Connection type to perform the check. Required
     */
    public String getProtocol()
    {
        return protocol;
    }

    public void setProtocol(final String protocol)
    {
        this.protocol = protocol;
    }

    /**
     * Identifies the health check in the provider.
     */
    public String getProviderId()
    {
        return providerId;
    }

    public void setProviderId(final String providerId)
    {
        this.providerId = providerId;
    }

    /**
     * Time between checks. Required
     */
    public long getIntervalInMs()
    {
        return intervalInMs;
    }

    public void setIntervalInMs(final long intervalInMs)
    {
        this.intervalInMs = intervalInMs;
    }

    /**
     * Time to wait during the check. Required
     */
    public long getTimeoutInMs()
    {
        return timeoutInMs;
    }

    public void setTimeoutInMs(final long timeoutInMs)
    {
        this.timeoutInMs = timeoutInMs;
    }

    /**
     * Number of consecutive health probe failures required before moving the instance to the
     * isOutOfService state. [1,10]
     */
    public int getAttempts()
    {
        return attempts;
    }

    public void setAttempts(final int attempts)
    {
        this.attempts = attempts;
    }

    /** Where open the connection during the check. [0, 65535] */
    public int getPort()
    {
        return port;
    }

    public void setPort(final int port)
    {
        this.port = port;
    }

    /**
     * Regular expression to match a healthy node during check response status. (example
     * ''^[234][0-9][0-9]$'')
     */
    public String getStatusRegex()
    {
        return statusRegex;
    }

    public void setStatusRegex(final String statusRegex)
    {
        this.statusRegex = statusRegex;
    }

    /** Regular expression to match a healthy node during check response body. */
    public String getBodyRegex()
    {
        return bodyRegex;
    }

    public void setBodyRegex(final String bodyRegex)
    {
        this.bodyRegex = bodyRegex;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }
}
