/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.cloud;

import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;

import com.abiquo.model.transport.SingleResourceTransportDto;

@XmlRootElement(name = "hypervisor")
public class HypervisorDiscoveryDto extends SingleResourceTransportDto
{

    private static final String TYPE = "application/vnd.abiquo.hypervisordiscovery";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    private Integer port;

    private String ipFrom;

    private String ipTo;

    private String type;

    private String user;

    private String password;

    private String vSwitch;

    /**
     * Hypervisor port
     * 
     * @return
     */
    @NotNull
    public Integer getPort()
    {
        return port;
    }

    public void setPort(final Integer port)
    {
        this.port = port;
    }

    /**
     * Starting IP
     * 
     * @return
     */
    @NotNull
    public String getIpFrom()
    {
        return ipFrom;
    }

    public void setIpFrom(final String ipFrom)
    {
        this.ipFrom = ipFrom;
    }

    /**
     * Ending IP
     * 
     * @return
     */
    @NotNull
    public String getIpTo()
    {
        return ipTo;
    }

    public void setIpTo(final String ipTo)
    {
        this.ipTo = ipTo;
    }

    /**
     * Hypervisor type
     * 
     * @return
     */
    @NotNull
    public String getType()
    {
        return type;
    }

    public void setType(final String type)
    {
        this.type = type;
    }

    /**
     * Hypervisor credentials
     * 
     * @return
     */
    @NotNull
    public String getUser()
    {
        return user;
    }

    public void setUser(final String user)
    {
        this.user = user;
    }

    /**
     * Hypervisor password
     * 
     * @return
     */
    @NotNull
    public String getPassword()
    {
        return password;
    }

    public void setPassword(final String password)
    {
        this.password = password;
    }

    /**
     * VSwitch
     * 
     * @return
     */
    @NotNull
    public String getvSwitch()
    {
        return vSwitch;
    }

    public void setvSwitch(final String vSwitch)
    {
        this.vSwitch = vSwitch;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }

}
