/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.cloud;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import com.abiquo.model.adapter.PluginConstraintsJsonAdapter;
import com.abiquo.model.adapter.PluginConstraintsXmlAdapter;
import com.abiquo.model.adapter.PluginOperationsXmlAdapter;
import com.abiquo.model.transport.SingleResourceTransportDto;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

@XmlRootElement(name = "hypervisortype")
public class HypervisorTypeDto extends SingleResourceTransportDto
{
    private static final String TYPE = "application/vnd.abiquo.hypervisortype";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    private static final long serialVersionUID = -6899075534020087650L;

    private String baseFormat;

    private List<String> compatibilityTable;

    private String name;

    private String realName;

    private Map<String, String> constraints = new HashMap<String, String>();

    private Map<String, Map<String, List<String>>> operations = new HashMap<>();

    /**
     * Base format of the hypervisor type
     * 
     * @return
     */
    @NotNull
    @XmlElement(name = "baseformat")
    public String getBaseFormat()
    {
        return baseFormat;
    }

    public void setBaseFormat(final String baseFormat)
    {
        this.baseFormat = baseFormat;
    }

    /**
     * Compatibility of the hypervisor type
     * 
     * @return
     */
    @XmlElementWrapper(name = "compatibleformats")
    @XmlElement(name = "format")
    public List<String> getCompatibilityTable()
    {
        return compatibilityTable;
    }

    public void setCompatibilityTable(final List<String> compatibilityTable)
    {
        this.compatibilityTable = compatibilityTable;
    }

    /**
     * Name of the hypervisor type
     * 
     * @return
     */
    @NotNull
    public String getName()
    {
        return name;
    }

    public void setName(final String name)
    {
        this.name = name;
    }

    /**
     * Friendly name of the hypervisor type
     * 
     * @return
     */
    @NotNull
    public String getRealName()
    {
        return realName;
    }

    public void setRealName(final String realName)
    {
        this.realName = realName;
    }

    @XmlAnyElement
    @XmlJavaTypeAdapter(PluginConstraintsXmlAdapter.class)
    @JsonSerialize(using = PluginConstraintsJsonAdapter.class)
    public Map<String, String> getConstraints()
    {
        return constraints;
    }

    // XML deserialization needs a setter
    public void setConstraints(final Map<String, String> constraints)
    {
        this.constraints = constraints;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }

    @XmlAnyElement
    @XmlJavaTypeAdapter(PluginOperationsXmlAdapter.class)
    @JsonSerialize(using = PluginConstraintsJsonAdapter.class)
    public Map<String, Map<String, List<String>>> getOperations()
    {
        return operations;
    }

    public void setOperations(final Map<String, Map<String, List<String>>> operations)
    {
        this.operations = operations;
    }
}
