/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.cloud;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.transport.SingleResourceTransportDto;

/**
 * Address to be used to reach the {@link LoadBalancerDto}.
 */
@XmlRootElement(name = "loadbalanceraddress")
@XmlType(propOrder = {"endpoint", "providerId", "internal"})
public class LoadBalancerAddressDto extends SingleResourceTransportDto implements Serializable
{
    private static final long serialVersionUID = -211401433549048161L;

    /** The Constant BASE_MEDIA_TYPE. */
    private static final String TYPE = "application/vnd.abiquo.loadbalanceraddress";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    private String providerId;

    private String endpoint;

    private Boolean internal;

    /**
     * Identifies the load balancer address in the provider.
     */
    public String getProviderId()
    {
        return providerId;
    }

    public void setProviderId(final String providerId)
    {
        this.providerId = providerId;
    }

    /**
     * IP address or host name used to reach the {@link LoadBalancerDto}. Required
     */
    public String getEndpoint()
    {
        return endpoint;
    }

    public void setEndpoint(final String endpoint)
    {
        this.endpoint = endpoint;
    }

    /**
     * Type of the {@link #getEndpoint()}
     * <p>
     * {@code true} for private traffic, otherwise publicly accessible
     */
    @XmlElement(name = "internal")
    public Boolean isInternal()
    {
        return internal;
    }

    public void setInternal(final Boolean internal)
    {
        this.internal = internal;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }

}
