/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.cloud;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.transport.SingleResourceTransportDto;

/**
 * Define the configuration of the workload distribution across virtual machines.
 * <p>
 * NOTE registered virtual machines aren't included in this model.
 */
@XmlRootElement(name = "loadbalancer")
@XmlType(propOrder = {"name", "algorithm", "providerId", "loadBalancerAddresses", "routingRules",
"healthChecks"})
public class LoadBalancerDto extends SingleResourceTransportDto implements Serializable
{
    private static final long serialVersionUID = 3474662420976375345L;

    /** The Constant BASE_MEDIA_TYPE. */
    private static final String TYPE = "application/vnd.abiquo.loadbalancer";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    private String name;

    private String algorithm;

    private String providerId;

    /**
     * Friendly name. required
     */
    public String getName()
    {
        return name;
    }

    public void setName(final String name)
    {
        this.name = name;
    }

    /**
     * Distribution strategy. Provider could select a default one. Optional
     */
    public String getAlgorithm()
    {
        return algorithm;
    }

    public void setAlgorithm(final String algorithm)
    {
        this.algorithm = algorithm;
    }

    /**
     * Identifies the load balancer in the provider.
     */
    public String getProviderId()
    {
        return providerId;
    }

    public void setProviderId(final String providerId)
    {
        this.providerId = providerId;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }

    // // // embedded entities to be used during POST // // //

    private RoutingRulesDto routingRules;

    private LoadBalancerAddressesDto loadBalancerAddresses;

    private HealthChecksDto healthChecks;

    /** Embedded RoutingRules during creation */
    public RoutingRulesDto getRoutingRules()
    {
        return routingRules;
    }

    /** Embedded LoadBalancerAddresses during creation */
    public LoadBalancerAddressesDto getLoadBalancerAddresses()
    {
        return loadBalancerAddresses;
    }

    /** Embedded HealthChecks during creation */
    public HealthChecksDto getHealthChecks()
    {
        return healthChecks;
    }

    public void setRoutingRules(final RoutingRulesDto routingRules)
    {
        this.routingRules = routingRules;
    }

    public void setLoadBalancerAddresses(final LoadBalancerAddressesDto loadBalancerAddresses)
    {
        this.loadBalancerAddresses = loadBalancerAddresses;
    }

    public void setHealthChecks(final HealthChecksDto healthChecks)
    {
        this.healthChecks = healthChecks;
    }
}
