/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.cloud;

import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name = "managedhypervisor")
@XmlType(propOrder = {"managerPort", "managerIp", "managerUser", "managerPassword"})
public class ManagedHypervisorDto extends HypervisorDiscoveryDto
{

    private static final long serialVersionUID = 1539036861828494460L;

    private static final String TYPE = "application/vnd.abiquo.managedhypervisor";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    private Integer managerPort;

    private String managerIp;

    private String managerUser;

    private String managerPassword;

    /**
     * Manager Connection Port
     */
    @NotNull
    public Integer getManagerPort()
    {
        return managerPort;
    }

    public void setManagerPort(final Integer managerPort)
    {
        this.managerPort = managerPort;
    }

    /**
     * Manager Connection Ip
     */
    @NotNull
    public String getManagerIp()
    {
        return managerIp;
    }

    public void setManagerIp(final String managerIp)
    {
        this.managerIp = managerIp;
    }

    /**
     * Manager Connection User
     */
    @NotNull
    public String getManagerUser()
    {
        return managerUser;
    }

    public void setManagerUser(final String managerUser)
    {
        this.managerUser = managerUser;
    }

    /**
     * Manager Connection Password
     */
    @NotNull
    public String getManagerPassword()
    {
        return managerPassword;
    }

    public void setManagerPassword(final String managerPassword)
    {
        this.managerPassword = managerPassword;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }
}
