/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.cloud;

import java.util.Map;

import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import com.abiquo.model.adapter.MetadataJsonAdapter;
import com.abiquo.model.adapter.MetadataJsonSerializer;
import com.abiquo.model.transport.SingleResourceTransportDto;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

@XmlRootElement(name = "virtualmachinemetadata")
public class MetadataDto extends SingleResourceTransportDto
{

    private static final long serialVersionUID = 1L;

    private static final String TYPE = "application/vnd.abiquo.metadata";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    private Map<String, Object> metadata; // = new HashMap<String, Object>();

    @XmlAnyElement
    @XmlJavaTypeAdapter(ParameterAdapter.class)
    @JsonSerialize(using = MetadataJsonSerializer.class)
    @JsonDeserialize(using = MetadataJsonAdapter.class)
    public Map<String, Object> getMetadata()
    {
        return metadata;
    }

    /**
     * This method does an {@link Map#putAll(Map)} operation on the {@link #metadata} object.
     * 
     * @param metadata
     */
    public void setMetadata(final Map<String, Object> parameters)
    {
        this.metadata = parameters;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }
}
