/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.cloud;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.transport.SingleResourceTransportDto;

/**
 * Define forward functions in the {@link LoadBalancerDto}.
 */
@XmlRootElement(name = "routingrule")
@XmlType(propOrder = {"providerId", "portIn", "protocolIn", "portOut", "protocolOut",
"sslCertificate"})
public class RoutingRuleDto extends SingleResourceTransportDto implements Serializable
{

    private static final long serialVersionUID = -4894725614296130230L;

    /** The Constant BASE_MEDIA_TYPE. */
    private static final String TYPE = "application/vnd.abiquo.routingrule";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    private String providerId;

    private Integer portIn;

    private Integer portOut;

    private String protocolIn;

    private String protocolOut;

    private SSLCertificateDto sslCertificate;

    /**
     * Identifies the routing rule in the provider.
     */
    public String getProviderId()
    {
        return providerId;
    }

    public void setProviderId(final String providerId)
    {
        this.providerId = providerId;
    }

    /**
     * Inbound port. Required
     */
    public Integer getPortIn()
    {
        return portIn;
    }

    public void setPortIn(final Integer portIn)
    {
        this.portIn = portIn;
    }

    /**
     * Outbound port. Required
     */
    public Integer getPortOut()
    {
        return portOut;
    }

    public void setPortOut(final Integer portOut)
    {
        this.portOut = portOut;
    }

    /**
     * Inbound protocol. Required
     */
    public String getProtocolIn()
    {
        return protocolIn;
    }

    public void setProtocolIn(final String protocolIn)
    {
        this.protocolIn = protocolIn;
    }

    /**
     * Outbound protocol. Required
     */
    public String getProtocolOut()
    {
        return protocolOut;
    }

    public void setProtocolOut(final String protocolOut)
    {
        this.protocolOut = protocolOut;
    }

    /**
     * {@link SSLCertificateDto} to use while creating the routing rule. Optional
     */
    public SSLCertificateDto getSslCertificate()
    {
        return sslCertificate;
    }

    public void setSslCertificate(final SSLCertificateDto sslCertificate)
    {
        this.sslCertificate = sslCertificate;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }

}
