/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.cloud;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.transport.SingleResourceTransportDto;

/**
 * Describe the SSL certificate to be used.
 */
@XmlRootElement(name = "sslcertificate")
@XmlType(propOrder = {"name", "providerId", "certificate", "privateKey", "intermediateCertificate"})
public class SSLCertificateDto extends SingleResourceTransportDto implements Serializable
{
    private static final long serialVersionUID = 6802371093591387546L;

    /** The Constant BASE_MEDIA_TYPE. */
    private static final String TYPE = "application/vnd.abiquo.sslcertificate";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    private String name;

    private String providerId;

    private String certificate;

    private String privateKey;

    private String intermediateCertificate;

    /**
     * Friendly name. Required
     */
    public String getName()
    {
        return name;
    }

    public void setName(final String name)
    {
        this.name = name;
    }

    /**
     * Identifies the SSL certificate in the provider.
     */
    public String getProviderId()
    {
        return providerId;
    }

    public void setProviderId(final String providerId)
    {
        this.providerId = providerId;
    }

    /**
     * PEM encoded certificate. Required. Input field.
     */
    public String getCertificate()
    {
        return certificate;
    }

    public void setCertificate(final String certificate)
    {
        this.certificate = certificate;
    }

    /**
     * Key to verify the certificate. Required. Input field.
     */
    public String getPrivateKey()
    {
        return privateKey;
    }

    public void setPrivateKey(final String privateKey)
    {
        this.privateKey = privateKey;
    }

    /**
     * Additional certificates in the verification chain. Optional. Input field.
     */
    public String getIntermediateCertificate()
    {
        return intermediateCertificate;
    }

    public void setIntermediateCertificate(final String intermediateCertificate)
    {
        this.intermediateCertificate = intermediateCertificate;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }

}
