/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.cloud;

import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.transport.Expandable;
import com.abiquo.model.transport.SingleResourceTransportDto;
import com.abiquo.server.core.task.TaskDto;
import com.abiquo.server.core.task.TasksDto;

/**
 * The Class VirtualApplianceDto.
 */
@XmlRootElement(name = "virtualAppliance")
@XmlType(propOrder = {"id", "error", "highDisponibility", "expands", "name", "nodeconnections",
"publicApp", "state", "subState"})
public class VirtualApplianceDto extends SingleResourceTransportDto implements Expandable<TaskDto>
{

    /** The Constant COPY_VIRTUAL_APPLIANCE_MIME_TYPE. */
    public static final String COPY_VIRTUAL_APPLIANCE_MIME_TYPE =
        "application/vnd.cp-virtualappliance+xml";

    public static final String COPY_VIRTUAL_APPLIANCE_MIME_TYPE_JSON =
        "application/vnd.cp-virtualappliance+json";

    /** The Constant MOVE_VIRTUAL_APPLIANCE_MIME_TYPE. */
    public static final String MOVE_VIRTUAL_APPLIANCE_MIME_TYPE =
        "application/vnd.mv-virtualappliance+xml";

    public static final String MOVE_VIRTUAL_APPLIANCE_MIME_TYPE_JSON =
        "application/vnd.mv-virtualappliance+json";

    /** The Constant serialVersionUID. */
    private static final long serialVersionUID = 6614050007994524638L;

    private static final String TYPE = "application/vnd.abiquo.virtualappliance";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    /** The id. */
    private Integer id;

    /** The name. */
    private String name;

    /** The nodeconnections. */
    private String nodeconnections;

    /** The public app. */
    private int publicApp;

    /** The high disponibility. */
    private int highDisponibility;

    /** The error. */
    private int error;

    /** The sub state. */
    private VirtualApplianceState subState;

    /** The state. */
    private VirtualApplianceState state;

    /** TODO This should be abstracted. */
    private TasksDto expands;

    /*
     * (non-Javadoc)
     * @see com.abiquo.model.transport.SingleResourceTransportDto#getBaseMediaType()
     */
    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }

    /**
     * Was there an error on the last operation on any of its nodes?.
     * 
     * @output
     * @return the error
     */
    public int getError()
    {
        return error;
    }

    /**
     * Deprecated.
     * 
     * @deprecated
     * @return the high disponibility
     */
    @Deprecated
    public int getHighDisponibility()
    {
        return highDisponibility;
    }

    /**
     * Opaque ID of the virtual appliance.
     * 
     * @output
     * @return the id
     */
    public Integer getId()
    {
        return id;
    }

    /**
     * Last task of every virtual machine.
     * 
     * @output
     * @return the last tasks
     */
    @Override
    @XmlElement(name = "lastTasks")
    public TasksDto getExpands()
    {
        return expands;
    }

    /*
     * (non-Javadoc)
     * @see com.abiquo.model.transport.SingleResourceTransportDto#getMediaType()
     */
    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    /**
     * Name of the virtual appliance.
     * 
     * @return the name
     */
    @NotNull
    public String getName()
    {
        return name;
    }

    /**
     * Logical connections made through the Abiquo flex client.
     * 
     * @return the nodeconnections
     */
    public String getNodeconnections()
    {
        return nodeconnections;
    }

    /**
     * Deprecated.
     * 
     * @deprecated
     * @return the public app
     */
    @Deprecated
    public int getPublicApp()
    {
        return publicApp;
    }

    /**
     * Current state. Inferred from its virtual machines
     * 
     * @output
     * @return the state
     */
    public VirtualApplianceState getState()
    {
        return state;
    }

    /**
     * Deprecated.
     * 
     * @return the sub state
     */
    public VirtualApplianceState getSubState()
    {
        return subState;
    }

    /**
     * Sets the error.
     * 
     * @param error the new error
     */
    public void setError(final int error)
    {
        this.error = error;
    }

    /**
     * Sets the high disponibility.
     * 
     * @param highDisponibility the new high disponibility
     */
    public void setHighDisponibility(final int highDisponibility)
    {
        this.highDisponibility = highDisponibility;
    }

    /**
     * Sets the id.
     * 
     * @param id the new id
     */
    public void setId(final Integer id)
    {
        this.id = id;
    }

    /**
     * Sets the last tasks.
     * 
     * @param expands the new last tasks
     */
    public void setExpands(final TasksDto expands)
    {
        this.expands = expands;
    }

    /**
     * Sets the name.
     * 
     * @param name the new name
     */
    public void setName(final String name)
    {
        this.name = name;
    }

    /**
     * Sets the nodeconnections.
     * 
     * @param nodeconnections the new nodeconnections
     */
    public void setNodeconnections(final String nodeconnections)
    {
        this.nodeconnections = nodeconnections;
    }

    /**
     * Sets the public app.
     * 
     * @param publicApp the new public app
     */
    public void setPublicApp(final int publicApp)
    {
        this.publicApp = publicApp;
    }

    /**
     * Sets the state.
     * 
     * @param state the new state
     */
    public void setState(final VirtualApplianceState state)
    {
        this.state = state;
    }

    /**
     * Sets the sub state.
     * 
     * @param subState the new sub state
     */
    public void setSubState(final VirtualApplianceState subState)
    {
        this.subState = subState;
    }

}
