/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.cloud;

import java.math.BigDecimal;

import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.transport.SingleResourceTransportDto;

/**
 * The Class VirtualAppliancePriceDto.
 */
@XmlRootElement(name = "virtualAppliancePrice")
@XmlType(propOrder = {"additionalVolumCost", "antiaffinityCost", "computeCost", "costCodeCost",
"minimumCharge", "minimumChargePeriod", "networkCost", "standingCharge", "storageCost", "totalCost"})
public class VirtualAppliancePriceDto extends SingleResourceTransportDto
{

    /** The Constant serialVersionUID. */
    private static final long serialVersionUID = 1L;

    private static final String TYPE = "application/vnd.abiquo.virtualapplianceprice";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    /**
     * Instantiates a new virtual appliance price dto.
     */
    public VirtualAppliancePriceDto()
    {
    }

    /**
     * Instantiates a new virtual appliance price dto.
     * 
     * @param costCodeCost the cost code cost
     * @param computeCost the compute cost
     * @param networkCost the network cost
     * @param storageCost the storage cost
     * @param additionalVolumCost the additional volume cost
     * @param antiaffinityCost the antiaffinity cost
     * @param totalCost the total cost
     */
    public VirtualAppliancePriceDto(final BigDecimal costCodeCost, final BigDecimal computeCost,
        final BigDecimal networkCost, final BigDecimal storageCost,
        final BigDecimal additionalVolumCost, final BigDecimal antiaffinityCost,
        final BigDecimal totalCost)
    {
        super();
        this.costCodeCost = costCodeCost;
        this.computeCost = computeCost;
        this.networkCost = networkCost;
        this.storageCost = storageCost;
        this.additionalVolumCost = additionalVolumCost;
        this.antiaffinityCost = antiaffinityCost;
        this.totalCost = totalCost;
    }

    /** Value for the image being deployed. */
    private BigDecimal costCodeCost;

    /** Value for the CPU, memory. */
    private BigDecimal computeCost;

    /** Value for public IPs. */
    private BigDecimal networkCost;

    /** Value for the datastore. */
    private BigDecimal storageCost;

    /** Value for the volume. */
    private BigDecimal additionalVolumCost;

    /** Value for antiaffinity. */
    private BigDecimal antiaffinityCost;

    /** Value for deploy. */
    private BigDecimal standingCharge;

    /** Value total. */
    private BigDecimal totalCost;

    /** The minimum charge. */
    private Integer minimumCharge;

    /** The minimum charge period. */
    private BigDecimal minimumChargePeriod;

    /**
     * Value for minimum charge period.
     * 
     * @return the minimum charge period
     */
    @NotNull
    public BigDecimal getMinimumChargePeriod()
    {
        return minimumChargePeriod;
    }

    /**
     * Sets the minimum charge period.
     * 
     * @param minimumChargePeriod the new minimum charge period
     */
    public void setMinimumChargePeriod(final BigDecimal minimumChargePeriod)
    {
        this.minimumChargePeriod = minimumChargePeriod;
    }

    /**
     * Minimum Charge.
     * 
     * @return the minimum charge
     */
    @NotNull
    public Integer getMinimumCharge()
    {
        return minimumCharge;
    }

    /**
     * Sets the minimum charge.
     * 
     * @param minimumCharge the new minimum charge
     */
    public void setMinimumCharge(final Integer minimumCharge)
    {
        this.minimumCharge = minimumCharge;
    }

    /**
     * Value for the image being deployed.
     * 
     * @return the cost code cost
     */
    @NotNull
    public BigDecimal getCostCodeCost()
    {
        return costCodeCost;
    }

    /**
     * Sets the cost code cost.
     * 
     * @param costCodeCost the new cost code cost
     */
    public void setCostCodeCost(final BigDecimal costCodeCost)
    {
        this.costCodeCost = costCodeCost;
    }

    /**
     * Value for the CPU, memory.
     * 
     * @return the compute cost
     */
    @NotNull
    public BigDecimal getComputeCost()
    {
        return computeCost;
    }

    /**
     * Sets the compute cost.
     * 
     * @param computeCost the new compute cost
     */
    public void setComputeCost(final BigDecimal computeCost)
    {
        this.computeCost = computeCost;
    }

    /**
     * Value for public IPs.
     * 
     * @return the network cost
     */
    @NotNull
    public BigDecimal getNetworkCost()
    {
        return networkCost;
    }

    /**
     * Sets the network cost.
     * 
     * @param networkCost the new network cost
     */
    public void setNetworkCost(final BigDecimal networkCost)
    {
        this.networkCost = networkCost;
    }

    /**
     * Value for the datastore.
     * 
     * @return the storage cost
     */
    @NotNull
    public BigDecimal getStorageCost()
    {
        return storageCost;
    }

    /**
     * Sets the storage cost.
     * 
     * @param storageCost the new storage cost
     */
    public void setStorageCost(final BigDecimal storageCost)
    {
        this.storageCost = storageCost;
    }

    /**
     * Value for the volume.
     * 
     * @return the additional volume cost
     */
    @NotNull
    public BigDecimal getAdditionalVolumCost()
    {
        return additionalVolumCost;
    }

    /**
     * Sets the additional volume cost.
     * 
     * @param additionalVolumCost the new additional volume cost
     */
    public void setAdditionalVolumCost(final BigDecimal additionalVolumCost)
    {
        this.additionalVolumCost = additionalVolumCost;
    }

    /**
     * Value for deploy.
     * 
     * @return the standing charge
     */
    @NotNull
    public BigDecimal getStandingCharge()
    {
        return standingCharge;
    }

    /**
     * Sets the standing charge.
     * 
     * @param standingCharge the new standing charge
     */
    public void setStandingCharge(final BigDecimal standingCharge)
    {
        this.standingCharge = standingCharge;
    }

    /**
     * Value for antiaffinity.
     * 
     * @return the antiaffinity cost
     */
    @NotNull
    public BigDecimal getAntiaffinityCost()
    {
        return antiaffinityCost;
    }

    /**
     * Sets the antiaffinity cost.
     * 
     * @param antiaffinityCost the new antiaffinity cost
     */
    public void setAntiaffinityCost(final BigDecimal antiaffinityCost)
    {
        this.antiaffinityCost = antiaffinityCost;
    }

    /**
     * Value total.
     * 
     * @return the total cost
     */
    @NotNull
    public BigDecimal getTotalCost()
    {
        return totalCost;
    }

    /**
     * Sets the total cost.
     * 
     * @param totalCost the new total cost
     */
    public void setTotalCost(final BigDecimal totalCost)
    {
        this.totalCost = totalCost;
    }

    /*
     * (non-Javadoc)
     * @see com.abiquo.model.transport.SingleResourceTransportDto#getMediaType()
     */
    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    /*
     * (non-Javadoc)
     * @see com.abiquo.model.transport.SingleResourceTransportDto#getBaseMediaType()
     */
    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }
}
