/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.cloud;

/**
 * This class represents all of the possible states of a {@link VirtualAppliance}, which is derived
 * form the states of its {@link VirtualMachine}.
 * 
 * @author ssedano
 * @see com.abiquo.server.core.cloud.VirtualMachineState
 */
public enum VirtualApplianceState
{
    /**
     * All the virtual machines exists in the hypervisor and none is in the state
     * {@link com.abiquo.server.core.cloud.VirtualMachineState#UNKNOWN} nor
     * {@link com.abiquo.server.core.cloud.VirtualMachineState#LOCKED}.
     */
    DEPLOYED,
    /**
     * No virtual machines. Or None of the virtual machines exists in the hypervisor and none is in
     * the state {@link com.abiquo.server.core.cloud.VirtualMachineState#UNKNOWN} nor
     * {@link com.abiquo.server.core.cloud.VirtualMachineState#LOCKED}.
     */
    NOT_DEPLOYED,
    /**
     * Some virtual machines exists in the hypervisor and some does not and none is in the state
     * {@link com.abiquo.server.core.cloud.VirtualMachineState#UNKNOWN} nor
     * {@link com.abiquo.server.core.cloud.VirtualMachineState#LOCKED}.
     */
    NEEDS_SYNC,
    /**
     * Any of its virtual machines is in state
     * {@link com.abiquo.server.core.cloud.VirtualMachineState#LOCKED} and none is in the state
     * {@link com.abiquo.server.core.cloud.VirtualMachineState#UNKNOWN}
     */
    LOCKED,
    /**
     * Any of its virtual machines is in state
     * {@link com.abiquo.server.core.cloud.VirtualMachineState#UNKNOWN}.
     */
    UNKNOWN;

    // This should erased but enums does not work with
    // formula this bug https://hibernate.onjira.com/browse/HHH-6347

    public VirtualApplianceState getSafeNullValueOf(final String value)
    {
        for (VirtualApplianceState a : VirtualApplianceState.values())
        {
            if (a.name().equals(value))
            {
                return a;
            }
        }
        return null;
    }
}
