/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.cloud;

import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.transport.SingleResourceWithLimitsDto;
import com.abiquo.server.core.infrastructure.network.VLANNetworkDto;

/**
 * The Class VirtualDatacenterDto.
 * 
 * @restlink <link rel="datacenter" href="http://example.com/api/admin/datacenters/{datacenterId}"/>
 * @restlink <link rel="enterprise" href="http://example.com/api/admin/enterprises/{enterpriseId}"/>
 */
@XmlRootElement(name = "virtualDatacenter")
@XmlType(propOrder = {"id", "hypervisorType", "name", "vlan", "providerId"})
public class VirtualDatacenterDto extends SingleResourceWithLimitsDto
{

    /** The Constant serialVersionUID. */
    private static final long serialVersionUID = -2165018992377526633L;

    private static final String TYPE = "application/vnd.abiquo.virtualdatacenter";

    private static final String LIST_VDC_TYPE = "application/vnd.abiquo.listvirtualdatacenters";

    public static final String LIST_VDC_BASE_MEDIA_TYPE = LIST_VDC_TYPE + "+" + XML;

    public static final String LIST_VDC_MEDIA_TYPE_JSON = LIST_VDC_TYPE + "+" + JSON;

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON_26 = MEDIA_TYPE + VERSION_PARAM + API_VERSION_26;

    public static final String MEDIA_TYPE_JSON_27 = MEDIA_TYPE + VERSION_PARAM + API_VERSION_27;

    public static final String MEDIA_TYPE_JSON_28 = MEDIA_TYPE + VERSION_PARAM + API_VERSION_28;

    public static final String MEDIA_TYPE_JSON_29 = MEDIA_TYPE + VERSION_PARAM + API_VERSION_29;

    public static final String MEDIA_TYPE_XML_22 = SHORT_MEDIA_TYPE_XML + VERSION_PARAM
        + API_VERSION_22;

    public static final String MEDIA_TYPE_XML_23 = SHORT_MEDIA_TYPE_XML + VERSION_PARAM
        + API_VERSION_23;

    public static final String MEDIA_TYPE_XML_24 = SHORT_MEDIA_TYPE_XML + VERSION_PARAM
        + API_VERSION_24;

    public static final String MEDIA_TYPE_XML_26 = SHORT_MEDIA_TYPE_XML + VERSION_PARAM
        + API_VERSION_26;

    public static final String MEDIA_TYPE_XML_27 = SHORT_MEDIA_TYPE_XML + VERSION_PARAM
        + API_VERSION_27;

    public static final String MEDIA_TYPE_XML_28 = SHORT_MEDIA_TYPE_XML + VERSION_PARAM
        + API_VERSION_28;

    public static final String MEDIA_TYPE_XML_29 = SHORT_MEDIA_TYPE_XML + VERSION_PARAM
        + API_VERSION_29;

    /** The id. */
    private Integer id;

    /** The name. */
    private String name;

    /** The hypervisor type. */
    private String hypervisorType;

    /** The vlan network for this virtual datacenter. */
    private VLANNetworkDto vlan;

    /** The identifier used by public cloud provider. */
    private String providerId;

    /*
     * (non-Javadoc)
     * @see com.abiquo.model.transport.SingleResourceTransportDto#getBaseMediaType()
     */
    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }

    /**
     * Hypervisor type of the virtual datacenter. Virtualization technology supported for this
     * virtual datacenter.
     * 
     * @return the hypervisor type
     */
    @NotNull
    public String getHypervisorType()
    {
        return hypervisorType;
    }

    /**
     * Opaque ID of the virtual datacenter.
     * 
     * @output
     * @return the id
     */
    public Integer getId()
    {
        return id;
    }

    /*
     * (non-Javadoc)
     * @see com.abiquo.model.transport.SingleResourceTransportDto#getMediaType()
     */
    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    /**
     * Virtual datacenter's name.
     * 
     * @return the name
     */
    @NotNull
    public String getName()
    {
        return name;
    }

    /**
     * Virtual datacenter network.
     * 
     * @return the vlan
     */
    @NotNull
    @XmlElement(name = "network")
    public VLANNetworkDto getVlan()
    {
        return vlan;
    }

    /**
     * Sets the hypervisor type.
     * 
     * @param hypervisorType the new hypervisor type
     */
    public void setHypervisorType(final String hypervisorType)
    {
        this.hypervisorType = hypervisorType;
    }

    /**
     * Sets the id.
     * 
     * @param id the new id
     */
    public void setId(final Integer id)
    {
        this.id = id;
    }

    /**
     * Sets the name.
     * 
     * @param name the new name
     */
    public void setName(final String name)
    {
        this.name = name;
    }

    /**
     * Sets the vlan.
     * 
     * @param vlan the new vlan
     */
    public void setVlan(final VLANNetworkDto vlan)
    {
        this.vlan = vlan;
    }

    /**
     * Sets the identifier used by public cloud provider
     */
    public String getProviderId()
    {
        return providerId;
    }

    /**
     * Sets the identifier used by public cloud provider
     * 
     * @param providerId
     */
    public void setProviderId(final String providerId)
    {
        this.providerId = providerId;
    }

}
