/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.cloud;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.server.core.infrastructure.network.NicsDto;
import com.abiquo.server.core.infrastructure.storage.DisksManagementDto;
import com.abiquo.server.core.infrastructure.storage.VolumesManagementDto;

@XmlRootElement(name = "virtualMachineFlat")
@XmlType(propOrder = {"volumes", "disks", "nics"})
public class VirtualMachineFlatDto extends VirtualMachineDto
{
    private static final long serialVersionUID = 5351222177107731773L;

    private static final String TYPE = "application/vnd.abiquo.virtualmachineflat";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    public static final String CAPTURE_INDICATOR_REL = "imported";

    private VolumesManagementDto volumes;

    private DisksManagementDto disks;

    private NicsDto nics;

    public VolumesManagementDto getVolumes()
    {
        return volumes;
    }

    public void setVolumes(final VolumesManagementDto volumes)
    {
        this.volumes = volumes;
    }

    public DisksManagementDto getDisks()
    {
        return disks;
    }

    public void setDisks(final DisksManagementDto disks)
    {
        this.disks = disks;
    }

    public NicsDto getNics()
    {
        return nics;
    }

    public void setNics(final NicsDto nics)
    {
        this.nics = nics;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }
}
