/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.cloud;

import java.io.Serializable;

import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;

import com.abiquo.model.transport.SingleResourceTransportDto;

/**
 * DTO to modify state parameters of the machine.
 * 
 * @author ssedano
 */
@XmlRootElement(name = "virtualmachinestate")
public class VirtualMachineStateDto extends SingleResourceTransportDto implements Serializable
{

    private static final long serialVersionUID = 7891496375111061310L;

    private static final String TYPE = "application/vnd.abiquo.virtualmachinestate";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    /**
     * Machine state state. <br>
     * Values
     * <ul>
     * <li><b>OFF</b></li>
     * <li><b>ON</b></li>
     * <li><b>PAUSED</b></li>
     * </ul>
     */
    private VirtualMachineState state;

    /**
     * State of the virtual machine. Valid values are: OFF, ON or PAUSED
     * 
     * @return *
     *         <ul>
     *         <li><b>OFF</b></li>
     *         <li><b>ON</b></li>
     *         <li><b>PAUSED</b></li>
     *         </ul>
     */
    @NotNull
    public VirtualMachineState getState()
    {
        return state;
    }

    /**
     * Machine state state. <br>
     * Values *
     * <ul>
     * <li><b>OFF</b></li>
     * <li><b>ON</b></li>
     * <li><b>PAUSED</b></li>
     * </ul>
     * 
     * @param state *
     *            <ul>
     *            <li><b>OFF</b></li>
     *            <li><b>ON</b></li>
     *            <li><b>PAUSED</b></li>
     *            </ul>
     *            void
     */
    public void setState(final VirtualMachineState state)
    {
        this.state = state;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }
}
