/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.cloud;

import javax.xml.bind.annotation.XmlRootElement;

import com.abiquo.model.transport.SingleResourceTransportDto;

/**
 * DTO to deploy parameters of the virtual machine.
 * 
 * @author <a href="mailto:serafin.sedano@abiquo.com">Serafin Sedano</a>
 */
@XmlRootElement(name = "virtualmachinetask")
public class VirtualMachineTaskDto extends SingleResourceTransportDto
{
    private static final long serialVersionUID = -272879466628574960L;

    private static final String TYPE = "application/vnd.abiquo.virtualmachinetask";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_XML_24 = TYPE + "+" + XML + VERSION_PARAM
        + API_VERSION_24;

    public static final String MEDIA_TYPE_XML_26 = TYPE + "+" + XML + VERSION_PARAM
        + API_VERSION_26;

    public static final String MEDIA_TYPE_XML_27 = TYPE + "+" + XML + VERSION_PARAM
        + API_VERSION_27;

    public static final String MEDIA_TYPE_XML_28 = TYPE + "+" + XML + VERSION_PARAM
        + API_VERSION_28;

    public static final String MEDIA_TYPE_XML_29 = TYPE + "+" + XML + VERSION_PARAM
        + API_VERSION_29;

    public static final String MEDIA_TYPE_JSON_26 = TYPE + "+" + JSON + VERSION_PARAM
        + API_VERSION_26;

    public static final String MEDIA_TYPE_JSON_27 = TYPE + "+" + JSON + VERSION_PARAM
        + API_VERSION_27;

    public static final String MEDIA_TYPE_JSON_28 = TYPE + "+" + JSON + VERSION_PARAM
        + API_VERSION_28;

    public static final String MEDIA_TYPE_JSON_29 = TYPE + "+" + JSON + VERSION_PARAM
        + API_VERSION_29;

    /**
     * Force the soft limits defined for the virtual datacenter in the deploy. <br>
     * Values
     * <ul>
     * <li><b>false</b></li>
     * <li><b>true</b></li>
     * </ul>
     */
    private boolean forceVdcLimits;

    /**
     * Deprecated in 2.4.
     * 
     * @deprecated use {@link #forceVdcLimits}
     */
    @Deprecated
    private boolean forceEnterpriseSoftLimits;

    /**
     * Imported virtual machines and ''UNAVALABLE'' virtual machine templates does not have the disk
     * file stored in an Abiquo repository. If we undpeloy them, we have lost the image and it is
     * unrecoverable. Use it if you need to force the undeploy of imported VirtualMachines or its
     * being used a UNAVALABLE template.
     */
    private boolean forceUndeploy;

    /**
     * Force the soft limits defined for the virtual datacenter in the deploy. <br>
     * Values
     * <ul>
     * <li><b>false</b></li>
     * <li><b>true</b></li>
     * </ul>
     * 
     * @return <ul>
     *         <li><b>false</b></li>
     *         <li><b>true</b></li>
     *         </ul>
     */
    public boolean isForceVdcLimits()
    {
        return forceVdcLimits;
    }

    /**
     * Force the soft limits defined for the virtual datacenter in the deploy. <br>
     * Values
     * <ul>
     * <li><b>OFF</b></li>
     * <li><b>ON</b></li>
     * </ul>
     * 
     * @param power <ul>
     *            <li><b>OFF</b></li>
     *            <li><b>ON</b></li>
     *            </ul>
     *            void
     */
    public void setForceVdcLimits(final boolean forceVdcLimits)
    {
        this.forceVdcLimits = forceVdcLimits;
    }

    /**
     * @param forceUndeploy
     */
    public void setForceUndeploy(final boolean forceUndeploy)
    {
        this.forceUndeploy = forceUndeploy;
    }

    /**
     * Imported machines does not have the image stored in an Abiquo repo. If we undpeloy them, we
     * have lost the image and it is unrecoverable. Use it if you force to undeploy imported
     * VirtualMachines.
     * 
     * @return force.
     */
    public boolean getForceUndeploy()
    {
        return forceUndeploy;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }

    /** @deprecated in 2.4 use {@link #isForceVdcLimits()} */
    @Deprecated
    public boolean isForceEnterpriseSoftLimits()
    {
        return forceEnterpriseSoftLimits;
    }

    /** @deprecated in 2.4 use {@link #setForceVdcLimits(boolean)} */
    @Deprecated
    public void setForceEnterpriseSoftLimits(final boolean forceEnterpriseSoftLimits)
    {
        this.forceEnterpriseSoftLimits = forceEnterpriseSoftLimits;
    }

}
