/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.cloud;

import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

/**
 * @restlink <link rel="template" href=
 *           "example.com/api/admin/enterprises/{id}/datacenterrepositories/{id}/virtualmachinetemplates/{id}"
 *           />
 */
@XmlRootElement(name = "virtualmachinewithnode")
@XmlType(propOrder = {"nodeId", "nodeName", "x", "y"})
public class VirtualMachineWithNodeDto extends VirtualMachineDto
{
    private static final long serialVersionUID = -8877350185009627544L;

    public static final String TYPE = "application/vnd.abiquo.virtualmachinewithnode";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON_26 = MEDIA_TYPE + VERSION_PARAM + API_VERSION_26;

    public static final String MEDIA_TYPE_JSON_27 = MEDIA_TYPE + VERSION_PARAM + API_VERSION_27;

    public static final String MEDIA_TYPE_22 = TYPE + "+" + XML + VERSION_PARAM + API_VERSION_22;

    public static final String MEDIA_TYPE_23 = TYPE + "+" + XML + VERSION_PARAM + API_VERSION_23;

    public static final String MEDIA_TYPE_24 = TYPE + "+" + XML + VERSION_PARAM + API_VERSION_24;

    public static final String MEDIA_TYPE_26 = TYPE + "+" + XML + VERSION_PARAM + API_VERSION_26;

    public static final String MEDIA_TYPE_27 = TYPE + "+" + XML + VERSION_PARAM + API_VERSION_27;

    private Integer nodeId;

    private int x;

    private String nodeName;

    private int y;

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    /**
     * Node ID, nothing to do with the virtual machine ID
     */
    public Integer getNodeId()
    {
        return nodeId;
    }

    /**
     * Friendly name to be displayed. Only used in the Abiquo flex client
     */
    @NotNull
    public String getNodeName()
    {
        return nodeName;
    }

    /**
     * X coordinate
     */
    @NotNull
    public int getX()
    {
        return x;
    }

    /**
     * Y coordinate
     */
    @NotNull
    public int getY()
    {
        return y;
    }

    public void setNodeId(final Integer nodeId)
    {
        this.nodeId = nodeId;
    }

    public void setNodeName(final String nodeName)
    {
        this.nodeName = nodeName;
    }

    public void setX(final int x)
    {
        this.x = x;
    }

    public void setY(final int y)
    {
        this.y = y;
    }

    public VirtualMachineWithNodeDto()
    {

    }

    public VirtualMachineWithNodeDto(final VirtualMachineDto dto, final Integer nodeId,
        final String nodeName, final Integer x, final Integer y)
    {
        this.setLinks(dto.getLinks());
        this.setId(dto.getId());
        this.setName(dto.getName());
        this.setDescription(dto.getDescription());
        this.setRam(dto.getRam());
        this.setCpu(dto.getCpu());
        this.setCoresPerSocket(dto.getCoresPerSocket());
        this.setHdInBytes(dto.getHdInBytes());
        this.setVdrpPort(dto.getVdrpPort());
        this.setVdrpIP(dto.getVdrpIP());
        this.setVdrpEnabled(dto.getVdrpEnabled());
        this.setIdState(dto.getIdState());
        this.setState(dto.getState());
        this.setHighDisponibility(dto.getHighDisponibility());
        this.setType(dto.getType());
        this.setPassword(dto.getPassword());
        this.setUuid(dto.getUuid());
        this.setRunlist(dto.getRunlist());
        this.setKeymap(dto.getKeymap());
        this.setDvd(dto.getDvd());
        //
        this.setNodeId(nodeId);
        this.setNodeName(nodeName);
        this.setX(x);
        this.setY(y);
    }

}
