/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.cloud;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

/**
 * @restlink <link rel="template" href=
 *           "example.com/api/admin/enterprises/{id}/datacenterrepositories/{id}/virtualmachinetemplates/{id}"
 *           />
 */
@XmlRootElement(name = "virtualmachinewithnodeextended")
@XmlType(propOrder = {"userName", "userSurname", "enterpriseName"})
public class VirtualMachineWithNodeExtendedDto extends VirtualMachineWithNodeDto
{
    private static final long serialVersionUID = -4124890793051402691L;

    public static final String TYPE = "application/vnd.abiquo.virtualmachinewithnodeextended";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON_26 = MEDIA_TYPE + VERSION_PARAM + API_VERSION_26;

    public static final String MEDIA_TYPE_JSON_27 = MEDIA_TYPE + VERSION_PARAM + API_VERSION_27;

    public static final String MEDIA_TYPE_22 = TYPE + "+" + XML + VERSION_PARAM + API_VERSION_22;

    public static final String MEDIA_TYPE_23 = TYPE + "+" + XML + VERSION_PARAM + API_VERSION_23;

    public static final String MEDIA_TYPE_24 = TYPE + "+" + XML + VERSION_PARAM + API_VERSION_24;

    public static final String MEDIA_TYPE_26 = TYPE + "+" + XML + VERSION_PARAM + API_VERSION_26;

    public static final String MEDIA_TYPE_27 = TYPE + "+" + XML + VERSION_PARAM + API_VERSION_27;

    private String userName;

    private String userSurname;

    private String enterpriseName;

    /**
     * User's name who owns this virtual machine.
     * 
     * @output
     */
    public String getUserName()
    {
        return userName;
    }

    public void setUserName(final String userName)
    {
        this.userName = userName;
    }

    /**
     * User's surname who owns this virtual machine.
     * 
     * @output
     */
    public String getUserSurname()
    {
        return userSurname;
    }

    public void setUserSurname(final String userSurname)
    {
        this.userSurname = userSurname;
    }

    /**
     * Enterprise name to which belongs the user who owns this virtual machine.
     * 
     * @output
     */
    public String getEnterpriseName()
    {
        return enterpriseName;
    }

    public void setEnterpriseName(final String enterpriseName)
    {
        this.enterpriseName = enterpriseName;
    }

    public VirtualMachineWithNodeExtendedDto()
    {
    }

    public VirtualMachineWithNodeExtendedDto(final VirtualMachineWithNodeDto dto,
        final String userName, final String userSurname, final String enterpriseName)
    {
        super(dto, dto.getNodeId(), dto.getNodeName(), dto.getX(), dto.getY());

        this.setUserName(userName);
        this.setUserSurname(userSurname);
        this.setEnterpriseName(enterpriseName);
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }
}
