/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.cloud;

import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import com.abiquo.model.transport.WrapperDto;

@XmlRootElement(name = "virtualmachineswithnode")
public class VirtualMachinesWithNodeDto extends WrapperDto<VirtualMachineWithNodeDto>
{

    private static final long serialVersionUID = -1891560795147901395L;

    private static final String TYPE = "application/vnd.abiquo.virtualmachineswithnode";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON_26 = MEDIA_TYPE + VERSION_PARAM + API_VERSION_26;

    public static final String MEDIA_TYPE_JSON_27 = MEDIA_TYPE + VERSION_PARAM + API_VERSION_27;

    public static final String MEDIA_TYPE_22 = TYPE + "+" + XML + VERSION_PARAM + API_VERSION_22;

    public static final String MEDIA_TYPE_23 = TYPE + "+" + XML + VERSION_PARAM + API_VERSION_23;

    public static final String MEDIA_TYPE_24 = TYPE + "+" + XML + VERSION_PARAM + API_VERSION_24;

    public static final String MEDIA_TYPE_26 = TYPE + "+" + XML + VERSION_PARAM + API_VERSION_26;

    public static final String MEDIA_TYPE_27 = TYPE + "+" + XML + VERSION_PARAM + API_VERSION_27;

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }

    /*
     * List of virtual machines with node
     * @output
     */
    @Override
    @XmlElement(name = "virtualmachinewithnode")
    public List<VirtualMachineWithNodeDto> getCollection()
    {
        return collection;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }
}
