/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.cloud.chef;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.transport.SingleResourceTransportDto;

/**
 * The Class BootstrapDto.
 */
@XmlRootElement(name = "bootstrap")
@XmlType(propOrder = {"nodeName", "chefConfig"})
public class BootstrapDto extends SingleResourceTransportDto implements Serializable
{

    private static final String TYPE = "application/vnd.abiquo.bootstrap";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    @Deprecated
    private static final String OLD_TYPE = "application/vnd.abiquo.extended";

    @Deprecated
    public static final String OLD_BASE_MEDIA_TYPE = OLD_TYPE + "+" + XML;

    @Deprecated
    public static final String OLD_MEDIA_TYPE_JSON = OLD_TYPE + "+" + JSON;

    @Deprecated
    public static final String OLD_MEDIA_TYPE = OLD_BASE_MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    /** The Constant serialVersionUID. */
    private static final long serialVersionUID = 1L;

    /** The node name. */
    private String nodeName;

    /** The chef config. */
    private ChefBootstrap chefConfig;

    /**
     * Name of the chef node.
     * 
     * @output
     * @return the node name
     */
    @XmlElement(name = "node")
    public String getNodeName()
    {
        return nodeName;
    }

    /**
     * Sets the node name.
     * 
     * @param nodeName the new node name
     */
    public void setNodeName(final String nodeName)
    {
        this.nodeName = nodeName;
    }

    /**
     * Chef configuration.
     * 
     * @output
     * @return the chef config
     */
    @XmlElement(name = "chef")
    public ChefBootstrap getChefConfig()
    {
        return chefConfig;
    }

    /**
     * Sets the chef config.
     * 
     * @param chefConfig the new chef config
     */
    public void setChefConfig(final ChefBootstrap chefConfig)
    {
        this.chefConfig = chefConfig;
    }

    /**
     * The Class ChefBootstrap.
     */
    @XmlRootElement(name = "chef")
    @XmlType(propOrder = {"chefServerURL", "validatorName", "validationCertificate", "runlist",
    "attributes"})
    public static class ChefBootstrap implements Serializable
    {

        /** The Constant serialVersionUID. */
        private static final long serialVersionUID = 1L;

        /** The chef server url. */
        private String chefServerURL;

        /** The validator name. */
        private String validatorName;

        /** The validation certificate. */
        private String validationCertificate;

        /** The runlist. */
        private RunlistDto runlist = new RunlistDto();

        /** The JSON attributes for the node. */
        private String attributes;

        /**
         * URL of the Chef server.
         * 
         * @output
         * @return the chef server url
         */
        @XmlElement(name = "chef-server-url")
        public String getChefServerURL()
        {
            return chefServerURL;
        }

        /**
         * Sets the chef server url.
         * 
         * @param chefServerURL the new chef server url
         */
        public void setChefServerURL(final String chefServerURL)
        {
            this.chefServerURL = chefServerURL;
        }

        /**
         * Validation of the Chef client name.
         * 
         * @output
         * @return the validator name
         */
        @XmlElement(name = "validation-client-name")
        public String getValidatorName()
        {
            return validatorName;
        }

        /**
         * Sets the validator name.
         * 
         * @param validatorName the new validator name
         */
        public void setValidatorName(final String validatorName)
        {
            this.validatorName = validatorName;
        }

        /**
         * Chef validation certificate.
         * 
         * @output
         * @return the validation certificate
         */
        @XmlElement(name = "validation-cert")
        public String getValidationCertificate()
        {
            return validationCertificate;
        }

        /**
         * Sets the validation certificate.
         * 
         * @param validationCertificate the new validation certificate
         */
        public void setValidationCertificate(final String validationCertificate)
        {
            this.validationCertificate = validationCertificate;
        }

        /**
         * Chef list of items to run.
         * 
         * @output
         * @return the runlist
         */
        public RunlistDto getRunlist()
        {
            return runlist;
        }

        /**
         * Sets the runlist.
         * 
         * @param runlist the new runlist
         */
        public void setRunlist(final RunlistDto runlist)
        {
            this.runlist = runlist;
        }

        /**
         * JSON attrobutes to apply to the node.
         * 
         * @output
         * @return The JSON attributes to apply to the node.
         */
        public String getAttributes()
        {
            return attributes;
        }

        /**
         * Sets the JSON attributes to apply to the node.
         * 
         * @param attributes The JSON attributes to be applied to the node.
         */
        public void setAttributes(final String attributes)
        {
            this.attributes = attributes;
        }

        /**
         * The Class RunlistDto.
         */
        @XmlRootElement(name = "runlist")
        public static class RunlistDto implements Serializable
        {

            /** The Constant serialVersionUID. */
            private static final long serialVersionUID = 1L;

            /** The elements. */
            private List<String> elements = new LinkedList<String>();

            /**
             * Adds the.
             * 
             * @param element the element
             */
            public void add(final String element)
            {
                elements.add(element);
            }

            /**
             * Size.
             * 
             * @return the int
             */
            public int size()
            {
                return elements.size();
            }

            /**
             * The elements.
             * 
             * @return the elements
             */
            @XmlElement(name = "element")
            public List<String> getElements()
            {
                return elements;
            }

            /**
             * Sets the elements.
             * 
             * @param elements the new elements
             */
            public void setElements(final List<String> elements)
            {
                this.elements = elements;
            }
        }
    }

    /*
     * (non-Javadoc)
     * @see com.abiquo.model.transport.SingleResourceTransportDto#getMediaType()
     */
    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    /*
     * (non-Javadoc)
     * @see com.abiquo.model.transport.SingleResourceTransportDto#getBaseMediaType()
     */
    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }

}
