/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.cloud.chef;

import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.transport.SingleResourceTransportDto;

/**
 * The Class RunlistElementDto.
 */
@XmlRootElement(name = "element")
@XmlType(propOrder = {"name", "description", "priority", "selected"})
public class RunlistElementDto extends SingleResourceTransportDto
{

    /** The Constant serialVersionUID. */
    private static final long serialVersionUID = 1L;

    private static final String TYPE = "application/vnd.abiquo.runlistelement";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    @Deprecated
    private static final String OLD_TYPE = "application/vnd.abiquo.extended";

    @Deprecated
    public static final String OLD_BASE_MEDIA_TYPE = OLD_TYPE + "+" + XML;

    @Deprecated
    public static final String OLD_MEDIA_TYPE_JSON = OLD_TYPE + "+" + JSON;

    @Deprecated
    public static final String OLD_MEDIA_TYPE = OLD_BASE_MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    // Runlist elements should not return the ID, since the resource is not a regular resource in
    // the DB. It is synchronized with the Chef Server every time it is requested

    /** The name. */
    private String name;

    /** The description. */
    private String description;

    /** Whether the element is selected. */
    private boolean selected;

    /** The priority. */
    private int priority;

    /**
     * The name of the runlist element.
     * 
     * @return the name
     */
    @NotNull
    public String getName()
    {
        return name;
    }

    /**
     * Sets the name.
     * 
     * @param name the new name
     */
    public void setName(final String name)
    {
        this.name = name;
    }

    /**
     * The description of the runlist element.
     * 
     * @return the description
     */
    public String getDescription()
    {
        return description;
    }

    /**
     * Sets the description.
     * 
     * @param description the new description
     */
    public void setDescription(final String description)
    {
        this.description = description;
    }

    /**
     * Boolean flag indicating if the runlist element is selected for the virtual machine.
     * 
     * @return true, if is selected
     */
    @NotNull
    public boolean isSelected()
    {
        return selected;
    }

    /**
     * Sets the selected.
     * 
     * @param selected the new selected
     */
    public void setSelected(final boolean selected)
    {
        this.selected = selected;
    }

    /**
     * Order in which this runlist element should be applied.
     * 
     * @return the priority
     */
    @NotNull
    public int getPriority()
    {
        return priority;
    }

    /**
     * Sets the priority.
     * 
     * @param priority the new priority
     */
    public void setPriority(final int priority)
    {
        this.priority = priority;
    }

    /*
     * (non-Javadoc)
     * @see com.abiquo.model.transport.SingleResourceTransportDto#getMediaType()
     */
    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    /*
     * (non-Javadoc)
     * @see com.abiquo.model.transport.SingleResourceTransportDto#getBaseMediaType()
     */
    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }
}
