/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * 
 */
package com.abiquo.server.core.cloud.chef;

import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import com.abiquo.model.transport.WrapperDto;

/**
 * Represents a collection of {@link RunlistElementDto}.
 * 
 * @author ibarrera
 */
@XmlRootElement(name = "runlist")
public class RunlistElementsDto extends WrapperDto<RunlistElementDto>
{
    private static final long serialVersionUID = 1L;

    private static final String TYPE = "application/vnd.abiquo.runlistelements";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    private static final String TYPE_LOCAL = "application/vnd.abiquo.localrunlistelements";

    public static final String BASE_MEDIA_TYPE_LOCAL = TYPE_LOCAL + "+" + XML;

    public static final String MEDIA_TYPE_JSON_LOCAL = TYPE_LOCAL + "+" + JSON;

    public static final String MEDIA_TYPE_LOCAL = BASE_MEDIA_TYPE_LOCAL + VERSION_PARAM
        + API_VERSION;

    @Deprecated
    private static final String OLD_TYPE = "application/vnd.abiquo.extended";

    @Deprecated
    public static final String OLD_BASE_MEDIA_TYPE = OLD_TYPE + "+" + XML;

    @Deprecated
    public static final String OLD_MEDIA_TYPE_JSON = OLD_TYPE + "+" + JSON;

    @Deprecated
    public static final String OLD_MEDIA_TYPE = OLD_BASE_MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    /**
     * Run list
     * 
     * @output
     */
    @Override
    @XmlElement(name = "element")
    public List<RunlistElementDto> getCollection()
    {
        return collection;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }
}
