/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.cloud.metric;

import javax.xml.bind.annotation.XmlAttribute;

public class DatapointDto
{
    private long timestamp;

    @XmlAttribute(required = false)
    private Double doubleValue;

    @XmlAttribute(required = false)
    private Long longValue;

    public DatapointDto()
    {
    }

    public DatapointDto(final long timestamp, final double value)
    {
        this.timestamp = timestamp;
        this.doubleValue = value;
        this.longValue = null;
    }

    public DatapointDto(final long timestamp, final long value)
    {
        this.timestamp = timestamp;
        this.doubleValue = null;
        this.longValue = value;
    }

    public long getTimestamp()
    {
        return timestamp;
    }

    public void setTimestamp(final long timestamp)
    {
        this.timestamp = timestamp;
    }

    public Double getDoubleValue()
    {
        return doubleValue;
    }

    public void setDoubleValue(final Double doubleValue)
    {
        if (doubleValue != null)
        {
            this.doubleValue = doubleValue;
            this.longValue = null;
        }
    }

    public Long getLongValue()
    {
        return longValue;
    }

    public void setLongValue(final Long longValue)
    {
        if (longValue != null)
        {
            this.longValue = longValue;
            this.doubleValue = null;
        }
    }
}
