/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.enterprise;

import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import com.abiquo.model.transport.WrapperDto;

@XmlRootElement(name = "limits")
public class DatacentersLimitsDto extends WrapperDto<DatacenterLimitsDto>
{
    private static final long serialVersionUID = 5578150660434591881L;

    private static final String TYPE = "application/vnd.abiquo.limits";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_XML_22 = SHORT_MEDIA_TYPE_XML + VERSION_PARAM
        + API_VERSION_22;

    public static final String MEDIA_TYPE_XML_23 = SHORT_MEDIA_TYPE_XML + VERSION_PARAM
        + API_VERSION_23;

    public static final String MEDIA_TYPE_XML_24 = SHORT_MEDIA_TYPE_XML + VERSION_PARAM
        + API_VERSION_24;

    public static final String MEDIA_TYPE_XML_26 = SHORT_MEDIA_TYPE_XML + VERSION_PARAM
        + API_VERSION_26;

    public static final String MEDIA_TYPE_XML_27 = SHORT_MEDIA_TYPE_XML + VERSION_PARAM
        + API_VERSION_27;

    public static final String MEDIA_TYPE_XML_28 = SHORT_MEDIA_TYPE_XML + VERSION_PARAM
        + API_VERSION_28;

    public static final String MEDIA_TYPE_XML_29 = SHORT_MEDIA_TYPE_XML + VERSION_PARAM
        + API_VERSION_29;

    public static final String MEDIA_TYPE_JSON_26 = MEDIA_TYPE_JSON + VERSION_PARAM
        + API_VERSION_26;

    public static final String MEDIA_TYPE_JSON_27 = MEDIA_TYPE_JSON + VERSION_PARAM
        + API_VERSION_27;

    public static final String MEDIA_TYPE_JSON_28 = MEDIA_TYPE_JSON + VERSION_PARAM
        + API_VERSION_28;

    public static final String MEDIA_TYPE_JSON_29 = MEDIA_TYPE_JSON + VERSION_PARAM
        + API_VERSION_29;

    @Override
    @XmlElement(name = "limit")
    public List<DatacenterLimitsDto> getCollection()
    {
        return collection;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }
}
