/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.enterprise;

import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.transport.SingleResourceWithAllLimitsDto;

/**
 * The Enterprise entity offers the functionality of managing the enterprise infrastructure in a
 * logical way.
 * 
 * @author destevezg
 */
@XmlRootElement(name = "enterprise")
@XmlType(propOrder = {"id", "name", "chefURL", "chefClient", "chefClientCertificate",
"chefValidator", "chefValidatorCertificate", "isReservationRestricted", "idPricingTemplate",
"workflow"})
public class EnterpriseDto extends SingleResourceWithAllLimitsDto
{
    private static final long serialVersionUID = 1L;

    private static final String TYPE = "application/vnd.abiquo.enterprise";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON_26 = MEDIA_TYPE + VERSION_PARAM + API_VERSION_26;

    public static final String MEDIA_TYPE_JSON_27 = MEDIA_TYPE + VERSION_PARAM + API_VERSION_27;

    public static final String MEDIA_TYPE_JSON_28 = MEDIA_TYPE + VERSION_PARAM + API_VERSION_28;

    public static final String MEDIA_TYPE_JSON_29 = MEDIA_TYPE + VERSION_PARAM + API_VERSION_29;

    public static final String MEDIA_TYPE_XML_22 = SHORT_MEDIA_TYPE_XML + VERSION_PARAM
        + API_VERSION_22;

    public static final String MEDIA_TYPE_XML_23 = SHORT_MEDIA_TYPE_XML + VERSION_PARAM
        + API_VERSION_23;

    public static final String MEDIA_TYPE_XML_24 = SHORT_MEDIA_TYPE_XML + VERSION_PARAM
        + API_VERSION_24;

    public static final String MEDIA_TYPE_XML_26 = SHORT_MEDIA_TYPE_XML + VERSION_PARAM
        + API_VERSION_26;

    public static final String MEDIA_TYPE_XML_27 = SHORT_MEDIA_TYPE_XML + VERSION_PARAM
        + API_VERSION_27;

    public static final String MEDIA_TYPE_XML_28 = SHORT_MEDIA_TYPE_XML + VERSION_PARAM
        + API_VERSION_28;

    public static final String MEDIA_TYPE_XML_29 = SHORT_MEDIA_TYPE_XML + VERSION_PARAM
        + API_VERSION_29;

    private Integer id;

    private String name;

    private String chefURL;

    private String chefClient;

    private String chefValidator;

    private String chefClientCertificate;

    private String chefValidatorCertificate;

    private boolean isReservationRestricted;

    private Integer idPricingTemplate;

    private boolean workflow;

    /**
     * Identifier of the Entity
     * 
     * @output
     * @output
     */
    public Integer getId()
    {
        return id;
    }

    public void setId(final Integer id)
    {
        this.id = id;
    }

    /**
     * The name of the Enterprise
     * 
     * @output
     */
    @NotNull
    public String getName()
    {
        return name;
    }

    public void setName(final String name)
    {
        this.name = name;
    }

    /**
     * URL of the Chef Server containing recipes
     * 
     * @output
     */
    public String getChefURL()
    {
        return chefURL;
    }

    public void setChefURL(final String chefURL)
    {
        this.chefURL = chefURL;
    }

    /**
     * This must be a Chef admin client on the chef server. The Abiquo Server will use it to work
     * with the Chef Server
     * 
     * @output
     */
    public String getChefClient()
    {
        return chefClient;
    }

    public void setChefClient(final String chefClient)
    {
        this.chefClient = chefClient;
    }

    /**
     * The validator client is used to create nodes. You must use the name of the validator client
     * on the chef server
     * 
     * @output
     */
    public String getChefValidator()
    {
        return chefValidator;
    }

    public void setChefValidator(final String chefValidator)
    {
        this.chefValidator = chefValidator;
    }

    /**
     * The admin client certificate, which may be stored in a file called adminclient.pem
     * 
     * @output
     */
    public String getChefClientCertificate()
    {
        return chefClientCertificate;
    }

    public void setChefClientCertificate(final String chefClientCertificate)
    {
        this.chefClientCertificate = chefClientCertificate;
    }

    /**
     * The validator certificate, which may be stored in a file called organization-validator or
     * validation.pem
     * 
     * @output
     */

    public String getChefValidatorCertificate()
    {
        return chefValidatorCertificate;
    }

    public void setChefValidatorCertificate(final String chefValidatorCertificate)
    {
        this.chefValidatorCertificate = chefValidatorCertificate;
    }

    /**
     * You can also restrict an enterprise so that it may only deploy virtual machines on the
     * physical machines reserved for it and not on any others
     * 
     * @output
     */

    public boolean getIsReservationRestricted()
    {
        return isReservationRestricted;
    }

    public void setIsReservationRestricted(final boolean isReservationRestricted)
    {
        this.isReservationRestricted = isReservationRestricted;
    }

    /**
     * Identifier for the pricing template associated to this enterprise
     * 
     * @output
     */
    public Integer getIdPricingTemplate()
    {
        return idPricingTemplate;
    }

    public void setIdPricingTemplate(final Integer idPricingTemplate)
    {
        this.idPricingTemplate = idPricingTemplate;
    }

    public boolean isWorkflow()
    {
        return workflow;
    }

    /**
     * @param workflow whether this tenant must honor workflow
     */
    public void setWorkflow(final boolean workflow)
    {
        this.workflow = workflow;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }

}
