/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.enterprise;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

/**
 * EnterpriseTheme entity offers Enterprise data plus information on associated custom theme
 * 
 * @author destevezg
 */
@XmlRootElement(name = "enterprisetheme")
@XmlType(propOrder = {"theme", "companyLogoPath"})
public class EnterpriseThemeDto extends EnterpriseDto
{
    private static final long serialVersionUID = -1121294329101175502L;

    private static final String TYPE = "application/vnd.abiquo.enterprisetheme";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON_26 = MEDIA_TYPE + VERSION_PARAM + API_VERSION_26;

    public static final String MEDIA_TYPE_JSON_27 = MEDIA_TYPE + VERSION_PARAM + API_VERSION_27;

    public static final String MEDIA_TYPE_JSON_28 = MEDIA_TYPE + VERSION_PARAM + API_VERSION_28;

    public static final String MEDIA_TYPE_JSON_29 = MEDIA_TYPE + VERSION_PARAM + API_VERSION_29;

    public static final String MEDIA_TYPE_XML_22 = SHORT_MEDIA_TYPE_XML + VERSION_PARAM
        + API_VERSION_22;

    public static final String MEDIA_TYPE_XML_23 = SHORT_MEDIA_TYPE_XML + VERSION_PARAM
        + API_VERSION_23;

    public static final String MEDIA_TYPE_XML_24 = SHORT_MEDIA_TYPE_XML + VERSION_PARAM
        + API_VERSION_24;

    public static final String MEDIA_TYPE_XML_26 = SHORT_MEDIA_TYPE_XML + VERSION_PARAM
        + API_VERSION_26;

    public static final String MEDIA_TYPE_XML_27 = SHORT_MEDIA_TYPE_XML + VERSION_PARAM
        + API_VERSION_27;

    public static final String MEDIA_TYPE_XML_28 = SHORT_MEDIA_TYPE_XML + VERSION_PARAM
        + API_VERSION_28;

    public static final String MEDIA_TYPE_XML_29 = SHORT_MEDIA_TYPE_XML + VERSION_PARAM
        + API_VERSION_29;

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    public void setTheme(final String theme)
    {
        this.theme = theme;
    }

    /**
     * Custom theme's name
     * 
     * @output
     */
    public String getTheme()
    {
        return theme;
    }

    public void setCompanyLogoPath(final String companyLogoPath)
    {
        this.companyLogoPath = companyLogoPath;
    }

    /**
     * Custom theme's logo path (image)
     * 
     * @output
     */
    public String getCompanyLogoPath()
    {
        return companyLogoPath;
    }

    private String theme;

    private String companyLogoPath;

}
