/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.enterprise;

import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.transport.SingleResourceTransportDto;

/**
 * Role entity offers the functionality of managing the platform roles in a logical way
 * 
 * @author destevezg
 */
@XmlRootElement(name = "role")
@XmlType(propOrder = {"id", "name", "blocked", "ldap", "idEnterprise"})
public class RoleDto extends SingleResourceTransportDto
{

    private static final long serialVersionUID = 1L;

    private static final String TYPE = "application/vnd.abiquo.role";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    public RoleDto()
    {
        super();
    }

    public RoleDto(final Integer id, final String name, final boolean blocked, final String ldap,
        final Integer idEnterprise)
    {
        super();
        this.id = id;
        this.name = name;
        this.blocked = blocked;
        this.ldap = ldap;
        this.idEnterprise = idEnterprise;
    }

    private Integer id;

    /**
     * Identifier for this role
     * 
     * @output
     */
    public Integer getId()
    {
        return id;
    }

    public void setId(final Integer id)
    {
        this.id = id;
    }

    private String name;

    /**
     * The name of the role
     * 
     * @return
     */
    @NotNull
    public String getName()
    {
        return name;
    }

    public void setName(final String name)
    {
        this.name = name;
    }

    private boolean blocked;

    /**
     * This role is not editable or changeable. Used for Cloud Admin
     * 
     * @output
     */
    public boolean isBlocked()
    {
        return blocked;
    }

    public void setBlocked(final boolean blocked)
    {
        this.blocked = blocked;
    }

    protected String ldap;

    /**
     * The LDAP group that the user belongs to. Required in LDAP mode
     * 
     * @output
     */
    public String getLdap()
    {
        return ldap;
    }

    public void setLdap(final String ldap)
    {
        this.ldap = ldap;
    }

    private Integer idEnterprise;

    /**
     * Identifier for the enterprise that the role belongs to. Leave empty for global (or system)
     * role
     * 
     * @output
     */
    public Integer getIdEnterprise()
    {
        return idEnterprise;
    }

    public void setIdEnterprise(final Integer idEnterprise)
    {
        this.idEnterprise = idEnterprise;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }
}
