/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.enterprise;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

/**
 * RoleWithPrivileges entity shows all privileges associated to a role
 * 
 * @author destevezg
 */
@XmlRootElement(name = "roleWithPrivileges")
@XmlType(propOrder = {"enterprise", "privileges"})
public class RoleWithPrivilegesDto extends RoleDto
{
    public RoleWithPrivilegesDto()
    {
    }

    public RoleWithPrivilegesDto(final RoleDto dto)
    {
        super();
        this.setBlocked(dto.isBlocked());
        this.setId(dto.getId());
        this.setIdEnterprise(dto.getIdEnterprise());
        this.setName(dto.getName());
        this.setLinks(dto.getLinks());
    }

    private PrivilegesDto privileges;

    private EnterpriseDto enterprise;

    /**
     * All privileges included in this role
     * 
     * @output
     */
    public PrivilegesDto getPrivileges()
    {
        return privileges;
    }

    public void setPrivileges(final PrivilegesDto privileges)
    {
        this.privileges = privileges;
    }

    /**
     * Enteprise associated to this role
     * 
     * @output 
     */
    public EnterpriseDto getEnterprise()
    {
        return enterprise;
    }

    public void setEnterprise(final EnterpriseDto enterprise)
    {
        this.enterprise = enterprise;
    }

    public RoleDto toRoleDto()
    {
        RoleDto dto = new RoleDto();
        dto.setId(this.getId());
        dto.setName(this.getName());
        dto.setBlocked(this.isBlocked());
        dto.setIdEnterprise(this.getIdEnterprise());
        dto.setLinks(this.getLinks());
        return dto;
    }

}
