/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.enterprise;

import java.util.List;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.transport.SingleResourceTransportDto;

@XmlType(propOrder = {"automaticAddDatacenter", "automaticAddEnterprise", "id", "name",
"scopeEntities"})
@XmlRootElement(name = "scope")
public class ScopeDto extends SingleResourceTransportDto
{

    private static final long serialVersionUID = 6399204236018610903L;

    private static final String TYPE = "application/vnd.abiquo.scope";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    private Integer id;

    /**
     * The id of the entity
     * 
     * @return
     */
    public Integer getId()
    {
        return id;
    }

    public void setId(final Integer id)
    {
        this.id = id;
    }

    private String name;

    /**
     * Name of the scope, name "Global scope" is reserved for default scope
     * 
     * @return
     */
    public String getName()
    {
        return name;
    }

    public void setName(final String name)
    {
        this.name = name;
    }

    private boolean automaticAddDatacenter;

    private boolean automaticAddEnterprise;

    private List<ScopeEntityDto> scopeEntities;

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    public void setScopeEntities(final List<ScopeEntityDto> scopes)
    {
        this.scopeEntities = scopes;
    }

    /**
     * All limit entities of a scope
     * 
     * @return
     */
    public List<ScopeEntityDto> getScopeEntities()
    {
        return scopeEntities;
    }

    public ScopeDto(final String name, final Integer idScope)
    {
        setName(name);
        setId(idScope);
    }

    public ScopeDto()
    {

    }

    public void setAutomaticAddDatacenter(final boolean automaticAddDatacenter)
    {
        this.automaticAddDatacenter = automaticAddDatacenter;
    }

    /**
     * true if all new datacenters created are added into this scope
     * 
     * @return
     */
    public boolean isAutomaticAddDatacenter()
    {
        return automaticAddDatacenter;
    }

    public void setAutomaticAddEnterprise(final boolean automaticAddEnterprise)
    {
        this.automaticAddEnterprise = automaticAddEnterprise;
    }

    /**
     * true if all new enterprises created are added into this scope
     * 
     * @return
     */
    public boolean isAutomaticAddEnterprise()
    {
        return automaticAddEnterprise;
    }
}
