/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.enterprise;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.transport.SingleResourceTransportDto;

/**
 * @restlink <link rel="scope" href="http://example.com/api/admin/scopes/{scopeId}/" />
 */

@XmlType(propOrder = {"id", "idResource", "type"})
@XmlRootElement(name = "scopeentity")
public class ScopeEntityDto extends SingleResourceTransportDto
{

    private static final String TYPE = "application/vnd.abiquo.scoperesource";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    public ScopeEntityDto()
    {
    }

    public ScopeEntityDto(final Integer id, final Integer idResource, final String type)
    {
        setId(id);
        setType(type);
        setIdResource(idResource);
    }

    private Integer id;

    /**
     * Id of the entity
     * 
     * @return
     */
    public Integer getId()
    {
        return id;
    }

    public void setId(final Integer id)
    {
        this.id = id;
    }


    private int idResource;

    /**
     * Identifier of the resource
     * 
     * @return
     */
    public int getIdResource()
    {
        return idResource;
    }

    public void setIdResource(final int idResource)
    {
        this.idResource = idResource;
    }

    private String type;

    /**
     * Type of the resource, can be 'ENTERPRISE' or 'DATACENTER' from version 2.2
     * 
     * @return
     */
    public String getType()
    {
        return type;
    }

    public void setType(final String type)
    {
        this.type = type;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

}
