/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.enterprise;

import java.util.Date;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.enumerator.AuthType;
import com.abiquo.model.transport.SingleResourceTransportDto;

/**
 * Representation of a session in the Abiquo UI
 */
@XmlRootElement(name = "session")
@XmlType(propOrder = {"id", "idUser", "nick", "key", "expirationDate", "authType"})
public class SessionDto extends SingleResourceTransportDto
{
    private static final long serialVersionUID = -3233121860012587479L;

    private static final String TYPE = "application/vnd.abiquo.session";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    private Integer id;

    private Integer idUser;

    private String nick;

    private String key;

    private Date expirationDate;

    private AuthType authType;

    /**
     * The identifier of the entity
     * 
     * @output
     */
    public Integer getId()
    {
        return id;
    }

    public void setId(final Integer id)
    {
        this.id = id;
    }

    /**
     * The id of the user associated with the session
     * 
     * @output
     */
    public Integer getIdUser()
    {
        return idUser;
    }

    public void setIdUser(final Integer idUser)
    {
        this.idUser = idUser;
    }

    /**
     * The username of the user associated with the session
     * 
     * @output
     */
    public String getNick()
    {
        return nick;
    }

    public void setNick(final String nick)
    {
        this.nick = nick;
    }

    /**
     * The session key
     * 
     * @output
     */
    public String getKey()
    {
        return key;
    }

    public void setKey(final String key)
    {
        this.key = key;
    }

    /**
     * The expiration date of the session
     * 
     * @output
     */
    public Date getExpirationDate()
    {
        return expirationDate;
    }

    public void setExpirationDate(final Date expirationDate)
    {
        this.expirationDate = expirationDate;
    }

    /**
     * The authentication type of the session
     * 
     * @output
     */
    public AuthType getAuthType()
    {
        return authType;
    }

    public void setAuthType(final AuthType authType)
    {
        this.authType = authType;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }
}
