/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.enterprise;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

/**
 * The UserWithRole entity offers the functionality of managing the users of an enterprise in a
 * logical way returning also its roles
 * 
 * @author destevezg
 */
@XmlRootElement(name = "userWithRole")
@XmlType(propOrder = {"role", "enterprise"})
public class UserWithRoleDto extends UserDto
{
    private static final long serialVersionUID = 1L;

    private static final String TYPE = "application/vnd.abiquo.userwithroles";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    private RoleWithPrivilegesDto role;

    private EnterpriseDto enterprise;

    /**
     * Role and privileges assigned to this user
     * 
     * @output
     */
    public RoleWithPrivilegesDto getRole()
    {
        return role;
    }

    public void setRole(final RoleWithPrivilegesDto role)
    {
        this.role = role;
    }

    /**
     * Enterprise for this user
     * 
     * @output
     */
    public EnterpriseDto getEnterprise()
    {
        return enterprise;
    }

    public void setEnterprise(final EnterpriseDto enterprise)
    {
        this.enterprise = enterprise;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }

}
