/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.event;

import java.util.Date;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.enumerator.SeverityType;
import com.abiquo.model.transport.SingleResourceTransportDto;

/**
 * The Class EventDto. Since Abiquo does not allow the creation of events through the API the whole
 * dto is read only.
 */
@XmlRootElement(name = "event")
@XmlType(propOrder = {"id", "actionPerformed", "component", "datacenter", "enterprise",
"idDatacenter", "idEnterprise", "idNetwork", "idPhysicalMachine", "idRack", "idStoragePool",
"idStorageSystem", "idSubnet", "idUser", "idVirtualApp", "idVirtualDatacenter", "idVirtualMachine",
"idVolume", "network", "performedBy", "physicalMachine", "rack", "severity", "stacktrace",
"storagePool", "storageSystem", "subnet", "timestamp", "user", "virtualApp", "virtualDatacenter",
"virtualMachine", "volume"})
public class EventDto extends SingleResourceTransportDto
{

    /** The Constant serialVersionUID. */
    private static final long serialVersionUID = -5357501732062265592L;

    private static final String TYPE = "application/vnd.abiquo.event";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    /** The id. */
    private Integer id;

    /** The stacktrace. */
    private String stacktrace;

    /** The component. */
    private String component;

    /** The performed by. */
    private String performedBy;

    /** The id network. */
    private Integer idNetwork;

    /** The id volume. */
    private String idVolume;

    /** The storage pool. */
    private String storagePool;

    /** The timestamp. */
    private Date timestamp;

    /** The virtual app. */
    private String virtualApp;

    /** The datacenter. */
    private String datacenter;

    /** The action performed. */
    private String actionPerformed;

    /** The id virtual machine. */
    private Integer idVirtualMachine;

    /** The virtual datacenter. */
    private String virtualDatacenter;

    /** The enterprise. */
    private String enterprise;

    /** The storage system. */
    private String storageSystem;

    /** The id physical machine. */
    private Integer idPhysicalMachine;

    /** The severity. */
    private SeverityType severity;

    /** The id storage system. */
    private Integer idStorageSystem;

    /** The id datacenter. */
    private Integer idDatacenter;

    /** The network. */
    private String network;

    /** The physical machine. */
    private String physicalMachine;

    /** The rack. */
    private String rack;

    /** The id virtual datacenter. */
    private Integer idVirtualDatacenter;

    /** The id subnet. */
    private Integer idSubnet;

    /** The volume. */
    private String volume;

    /** The subnet. */
    private String subnet;

    /** The id user. */
    private Integer idUser;

    /** The id storage pool. */
    private String idStoragePool;

    /** The user. */
    private String user;

    /** The id rack. */
    private Integer idRack;

    /** The virtual machine. */
    private String virtualMachine;

    /** The id virtual app. */
    private Integer idVirtualApp;

    /** The id enterprise. */
    private Integer idEnterprise;

    /**
     * The action performed.
     * 
     * @output
     * @return the action performed
     */
    public String getActionPerformed()
    {
        return actionPerformed;
    }

    /*
     * (non-Javadoc)
     * @see com.abiquo.model.transport.SingleResourceTransportDto#getBaseMediaType()
     */
    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }

    /**
     * The component.
     * <ul>
     * <li>API</li>
     * <li>APPLIANCE_MANAGER</li>
     * <li>COSTCODE</li>
     * <li>COSTCODE_CURRENCY</li>
     * <li>DATACENTER</li>
     * <li>ENTERPRISE</li>
     * <li>HIGH_AVAILABILITY</li>
     * <li>IMAGE_CONVERTER</li>
     * <li>INSTANCE_CONVERTER</li>
     * <li>LICENSE_MANAGER</li>
     * <li>MACHINE</li>
     * <li>NETWORK</li>
     * <li>PERSISTENT_CONVERTER</li>
     * <li>PLATFORM</li>
     * <li>PRICING_TEMPLATE</li>
     * <li>RACK</li>
     * <li>ROLE</li>
     * <li>ROLE_LDAP</li>
     * <li>SCOPE</li>
     * <li>STORAGE_DEVICE</li>
     * <li>STORAGE_POOL</li>
     * <li>UNKNOWN</li>
     * <li>USER</li>
     * <li>VIRTUAL_APPLIANCE</li>
     * <li>VIRTUAL_DATACENTER</li>
     * <li>VIRTUAL_MACHINE</li>
     * <li>VIRTUAL_STORAGE</li>
     * <li>VOLUME</li>
     * <li>WORKLOAD</li>
     * </ul>
     * 
     * @output
     * @return the component
     */
    public String getComponent()
    {
        return component;
    }

    /**
     * The datacenter where the event was triggered.
     * 
     * @output
     * @return the datacenter
     */
    public String getDatacenter()
    {
        return datacenter;
    }

    /**
     * The enterprise.
     * 
     * @output
     * @return the enterprise
     */
    public String getEnterprise()
    {
        return enterprise;
    }

    /**
     * The id of the event.
     * 
     * @output
     * @return the id
     */
    public Integer getId()
    {
        return id;
    }

    /**
     * The id datacenter where the event took place.
     * 
     * @output
     * @return the id datacenter
     */
    public Integer getIdDatacenter()
    {
        return idDatacenter;
    }

    /**
     * The id enterprise of the user's enterprise.
     * 
     * @output
     * @return the id enterprise
     */
    public Integer getIdEnterprise()
    {
        return idEnterprise;
    }

    /**
     * The id network if the action performed was over a network.
     * 
     * @output
     * @return the id network
     */
    public Integer getIdNetwork()
    {
        return idNetwork;
    }

    /**
     * The id physical machine if the action performed was over a physical machine.
     * 
     * @output
     * @return the id physical machine
     */
    public Integer getIdPhysicalMachine()
    {
        return idPhysicalMachine;
    }

    /**
     * The id rack if the action performed was over a rack.
     * 
     * @output
     * @return the id rack
     */
    public Integer getIdRack()
    {
        return idRack;
    }

    /**
     * The id storage pool if the action performed was over a storage pool.
     * 
     * @output
     * @return the id storage pool
     */
    public String getIdStoragePool()
    {
        return idStoragePool;
    }

    /**
     * The id storage system if the action performed was over a storage system.
     * 
     * @output
     * @return the id storage system
     */
    public Integer getIdStorageSystem()
    {
        return idStorageSystem;
    }

    /**
     * The id subnet if the action performed was over a subnet.
     * 
     * @output
     * @return the id subnet
     */
    public Integer getIdSubnet()
    {
        return idSubnet;
    }

    /**
     * The id user that triggered the event.
     * 
     * @output
     * @return the id user
     */
    public Integer getIdUser()
    {
        return idUser;
    }

    /**
     * The id virtual app if the action performed was over a virtual appliance.
     * 
     * @output
     * @return the id virtual app
     */
    public Integer getIdVirtualApp()
    {
        return idVirtualApp;
    }

    /**
     * The id virtual datacenter if the action performed was over a virtual datacenter.
     * 
     * @output
     * @return the id virtual datacenter
     */
    public Integer getIdVirtualDatacenter()
    {
        return idVirtualDatacenter;
    }

    /**
     * The id virtual machine if the action performed was over a virtual machine.
     * 
     * @output
     * @return the id virtual machine
     */
    public Integer getIdVirtualMachine()
    {
        return idVirtualMachine;
    }

    /**
     * The id volume if the action performed was over a volume.
     * 
     * @output
     * @return the id volume
     */
    public String getIdVolume()
    {
        return idVolume;
    }

    /*
     * (non-Javadoc)
     * @see com.abiquo.model.transport.SingleResourceTransportDto#getMediaType()
     */
    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    /**
     * The network if the action performed was over a network.
     * 
     * @output
     * @return the network
     */
    public String getNetwork()
    {
        return network;
    }

    /**
     * The performed by, who performed the action.
     * 
     * @output
     * @return the performed by
     */
    public String getPerformedBy()
    {
        return performedBy;
    }

    /**
     * The physical machine if the action performed was over a physical machine.
     * 
     * @output
     * @return the physical machine
     */
    public String getPhysicalMachine()
    {
        return physicalMachine;
    }

    /**
     * The rack if the action performed was over a rack.
     * 
     * @output
     * @return the rack
     */
    public String getRack()
    {
        return rack;
    }

    /**
     * The severity.
     * <ul>
     * <li>NORMAL</li>
     * <li>INFO</li>
     * <li>WARNING</li>
     * <li>MINOR</li>
     * <li>MAJOR</li>
     * <li>CRITICAL</li>
     * </ul>
     * 
     * @output
     * @return the severity
     */
    public SeverityType getSeverity()
    {
        return severity;
    }

    /**
     * The stacktrace. If the action is an error here is possible to look up the java stack trace.
     * 
     * @output
     * @return the stacktrace
     */
    public String getStacktrace()
    {
        return stacktrace;
    }

    /**
     * The storage pool if the action performed was over a storage pool.
     * 
     * @output
     * @return the storage pool
     */
    public String getStoragePool()
    {
        return storagePool;
    }

    /**
     * The storage system if the action performed was over a storage system.
     * 
     * @output
     * @return the storage system
     */
    public String getStorageSystem()
    {
        return storageSystem;
    }

    /**
     * The subnet if the action performed was over a subnet.
     * 
     * @output
     * @return the subnet
     */
    public String getSubnet()
    {
        return subnet;
    }

    /**
     * The timestamp. Time when the event took place.
     * 
     * @output
     * @return the timestamp
     */
    public Date getTimestamp()
    {
        return timestamp;
    }

    /**
     * The user whose performed the action.
     * 
     * @output
     * @return the user
     */
    public String getUser()
    {
        return user;
    }

    /**
     * The virtual app if the action performed was over a virtual appliance.
     * 
     * @output
     * @return the virtual app
     */
    public String getVirtualApp()
    {
        return virtualApp;
    }

    /**
     * The virtual datacenter if the action performed was over a virtual datacenter.
     * 
     * @output
     * @return the virtual datacenter
     */
    public String getVirtualDatacenter()
    {
        return virtualDatacenter;
    }

    /**
     * The virtual machine if the action performed was over a virtual machine.
     * 
     * @output
     * @return the virtual machine
     */
    public String getVirtualMachine()
    {
        return virtualMachine;
    }

    /**
     * The volume if the action performed was over a volume.
     * 
     * @output
     * @return the volume
     */
    public String getVolume()
    {
        return volume;
    }

    /**
     * Sets the action performed.
     * 
     * @param actionPerformed the new action performed
     */
    public void setActionPerformed(final String actionPerformed)
    {
        this.actionPerformed = actionPerformed;
    }

    /**
     * Sets the component.
     * 
     * @param component the new component
     */
    public void setComponent(final String component)
    {
        this.component = component;
    }

    /**
     * Sets the datacenter.
     * 
     * @param datacenter the new datacenter
     */
    public void setDatacenter(final String datacenter)
    {
        this.datacenter = datacenter;
    }

    /**
     * Sets the enterprise.
     * 
     * @param enterprise the new enterprise
     */
    public void setEnterprise(final String enterprise)
    {
        this.enterprise = enterprise;
    }

    /**
     * Sets the id.
     * 
     * @param id the new id
     */
    public void setId(final Integer id)
    {
        this.id = id;
    }

    /**
     * Sets the id datacenter.
     * 
     * @param idDatacenter the new id datacenter
     */
    public void setIdDatacenter(final Integer idDatacenter)
    {
        this.idDatacenter = idDatacenter;
    }

    /**
     * Sets the id enterprise.
     * 
     * @param idEnterprise the new id enterprise
     */
    public void setIdEnterprise(final Integer idEnterprise)
    {
        this.idEnterprise = idEnterprise;
    }

    /**
     * Sets the id network.
     * 
     * @param idNetwork the new id network
     */
    public void setIdNetwork(final Integer idNetwork)
    {
        this.idNetwork = idNetwork;
    }

    /**
     * Sets the id physical machine.
     * 
     * @param idPhysicalMachine the new id physical machine
     */
    public void setIdPhysicalMachine(final Integer idPhysicalMachine)
    {
        this.idPhysicalMachine = idPhysicalMachine;
    }

    /**
     * Sets the id rack.
     * 
     * @param idRack the new id rack
     */
    public void setIdRack(final Integer idRack)
    {
        this.idRack = idRack;
    }

    /**
     * Sets the id storage pool.
     * 
     * @param idStoragePool the new id storage pool
     */
    public void setIdStoragePool(final String idStoragePool)
    {
        this.idStoragePool = idStoragePool;
    }

    /**
     * Sets the id storage system.
     * 
     * @param idStorageSystem the new id storage system
     */
    public void setIdStorageSystem(final Integer idStorageSystem)
    {
        this.idStorageSystem = idStorageSystem;
    }

    /**
     * Sets the id subnet.
     * 
     * @param idSubnet the new id subnet
     */
    public void setIdSubnet(final Integer idSubnet)
    {
        this.idSubnet = idSubnet;
    }

    /**
     * Sets the id user.
     * 
     * @param idUser the new id user
     */
    public void setIdUser(final Integer idUser)
    {
        this.idUser = idUser;
    }

    /**
     * Sets the id virtual app.
     * 
     * @param idVirtualApp the new id virtual app
     */
    public void setIdVirtualApp(final Integer idVirtualApp)
    {
        this.idVirtualApp = idVirtualApp;
    }

    /**
     * Sets the id virtual datacenter.
     * 
     * @param idVirtualDatacenter the new id virtual datacenter
     */
    public void setIdVirtualDatacenter(final Integer idVirtualDatacenter)
    {
        this.idVirtualDatacenter = idVirtualDatacenter;
    }

    /**
     * Sets the id virtual machine.
     * 
     * @param idVirtualMachine the new id virtual machine
     */
    public void setIdVirtualMachine(final Integer idVirtualMachine)
    {
        this.idVirtualMachine = idVirtualMachine;
    }

    /**
     * Sets the id volume.
     * 
     * @param idVolume the new id volume
     */
    public void setIdVolume(final String idVolume)
    {
        this.idVolume = idVolume;
    }

    /**
     * Sets the network.
     * 
     * @param network the new network
     */
    public void setNetwork(final String network)
    {
        this.network = network;
    }

    /**
     * Sets the performed by.
     * 
     * @param performedBy the new performed by
     */
    public void setPerformedBy(final String performedBy)
    {
        this.performedBy = performedBy;
    }

    /**
     * Sets the physical machine.
     * 
     * @param physicalMachine the new physical machine
     */
    public void setPhysicalMachine(final String physicalMachine)
    {
        this.physicalMachine = physicalMachine;
    }

    /**
     * Sets the rack.
     * 
     * @param rack the new rack
     */
    public void setRack(final String rack)
    {
        this.rack = rack;
    }

    /**
     * Sets the severity.
     * 
     * @param severity the new severity
     */
    public void setSeverity(final SeverityType severity)
    {
        this.severity = severity;
    }

    /**
     * Sets the stacktrace.
     * 
     * @param stacktrace the new stacktrace
     */
    public void setStacktrace(final String stacktrace)
    {
        this.stacktrace = stacktrace;
    }

    /**
     * Sets the storage pool.
     * 
     * @param storagePool the new storage pool
     */
    public void setStoragePool(final String storagePool)
    {
        this.storagePool = storagePool;
    }

    /**
     * Sets the storage system.
     * 
     * @param storageSystem the new storage system
     */
    public void setStorageSystem(final String storageSystem)
    {
        this.storageSystem = storageSystem;
    }

    /**
     * Sets the subnet.
     * 
     * @param subnet the new subnet
     */
    public void setSubnet(final String subnet)
    {
        this.subnet = subnet;
    }

    /**
     * Sets the timestamp.
     * 
     * @param timestamp the new timestamp
     */
    public void setTimestamp(final Date timestamp)
    {
        this.timestamp = timestamp;
    }

    /**
     * Sets the user.
     * 
     * @param user the new user
     */
    public void setUser(final String user)
    {
        this.user = user;
    }

    /**
     * Sets the virtual app.
     * 
     * @param virtualApp the new virtual app
     */
    public void setVirtualApp(final String virtualApp)
    {
        this.virtualApp = virtualApp;
    }

    /**
     * Sets the virtual datacenter.
     * 
     * @param virtualDatacenter the new virtual datacenter
     */
    public void setVirtualDatacenter(final String virtualDatacenter)
    {
        this.virtualDatacenter = virtualDatacenter;
    }

    /**
     * Sets the virtual machine.
     * 
     * @param virtualMachine the new virtual machine
     */
    public void setVirtualMachine(final String virtualMachine)
    {
        this.virtualMachine = virtualMachine;
    }

    /**
     * Sets the volume.
     * 
     * @param volume the new volume
     */
    public void setVolume(final String volume)
    {
        this.volume = volume;
    }

}
