/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.event;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import com.abiquo.model.transport.SingleResourceTransportDto;

/**
 * The Class EventsDto.
 */
@XmlRootElement(name = "eventTypes")
public class EventTypesDto extends SingleResourceTransportDto
{

    /**
     * 
     */
    private static final long serialVersionUID = -3112278388446213671L;

    private static final String TYPE = "application/vnd.abiquo.eventtypes";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    private EventActionsDto actions;

    private EventSeveritiesDto severities;

    /*
     * (non-Javadoc)
     * @see com.abiquo.model.transport.SingleResourceTransportDto#getMediaType()
     */
    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    /*
     * (non-Javadoc)
     * @see com.abiquo.model.transport.SingleResourceTransportDto#getBaseMediaType()
     */
    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }

    @XmlElement(name = "actions")
    public EventActionsDto getActions()
    {
        return actions;
    }

    public void setActions(final EventActionsDto actions)
    {
        this.actions = actions;
    }

    @XmlElement(name = "severities")
    public EventSeveritiesDto getSeverities()
    {
        return severities;
    }

    public void setSeverities(final EventSeveritiesDto severities)
    {
        this.severities = severities;
    }
}
