/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * 
 */
package com.abiquo.server.core.infrastructure;

import java.util.ArrayList;
import java.util.List;

import com.abiquo.model.transport.WrapperDto;

/**
 * @author aprete
 */
public abstract class AbstractMachinesDto<T extends MachineDto> extends WrapperDto<T>
{
    private static final long serialVersionUID = 1L;

    protected List<T> collection = new ArrayList<T>();

    private Integer totalSize;

    @Override
    public void add(final T element)
    {
        collection.add(element);
    }

    @Override
    public void addAll(final WrapperDto<T> errors)
    {
        collection.addAll(errors.getCollection());
    }

    @Override
    public abstract List<T> getCollection();

    @Override
    public Integer getTotalSize()
    {
        return totalSize;
    }

    @Override
    public boolean isEmpty()
    {
        return collection.isEmpty();
    }

    @Override
    public void setTotalSize(final Integer totalSize)
    {
        this.totalSize = totalSize;
    }
}
