/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.infrastructure;

import java.io.Serializable;

import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.transport.SingleResourceTransportDto;

@XmlRootElement(name = "datacenter")
@XmlType(propOrder = {"id", "uuid", "name", "location", "remoteServices"})
public class DatacenterDto extends SingleResourceTransportDto implements Serializable
{
    private static final long serialVersionUID = 8359753288441318306L;

    private static final String TYPE = "application/vnd.abiquo.datacenter";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON_26 = MEDIA_TYPE + VERSION_PARAM + API_VERSION_26;

    public static final String MEDIA_TYPE_JSON_27 = MEDIA_TYPE + VERSION_PARAM + API_VERSION_27;

    public static final String MEDIA_TYPE_JSON_28 = MEDIA_TYPE + VERSION_PARAM + API_VERSION_28;

    public static final String MEDIA_TYPE_22 = TYPE + "+" + XML + VERSION_PARAM + API_VERSION_22;

    public static final String MEDIA_TYPE_23 = TYPE + "+" + XML + VERSION_PARAM + API_VERSION_23;

    public static final String MEDIA_TYPE_24 = TYPE + "+" + XML + VERSION_PARAM + API_VERSION_24;

    public static final String MEDIA_TYPE_26 = TYPE + "+" + XML + VERSION_PARAM + API_VERSION_26;

    public static final String MEDIA_TYPE_27 = TYPE + "+" + XML + VERSION_PARAM + API_VERSION_27;

    public static final String MEDIA_TYPE_28 = TYPE + "+" + XML + VERSION_PARAM + API_VERSION_28;

    /**
     * Identifier of the datacenter.
     */
    private Integer id;

    /**
     * Name of the datacenter.
     */
    private String name;

    /**
     * Where the Datacenter is located.
     */
    private String location;

    /**
     * Datacenter queue naming
     */
    private String uuid;

    /**
     * List of remote services of the datacenter.
     */
    private RemoteServicesDto remoteServices;

    /**
     * Identifier of the datacenter
     * 
     * @Output
     * @return the id
     */
    public Integer getId()
    {
        return id;
    }

    /**
     * @param id id to set
     */
    public void setId(final Integer id)
    {
        this.id = id;
    }

    /**
     * Name of the datacenter
     * 
     * @return the name
     */
    @NotNull
    public String getName()
    {
        return name;
    }

    /**
     * @param name name to set
     */
    public void setName(final String name)
    {
        this.name = name;
    }

    /**
     * Location of the datacenter
     * 
     * @return the location
     */
    @NotNull
    public String getLocation()
    {
        return location;
    }

    /**
     * @param location set the location
     */
    public void setLocation(final String location)
    {
        this.location = location;
    }

    /**
     * @param remoteServices the remoteServices to set
     */
    public void setRemoteServices(final RemoteServicesDto remoteServices)
    {
        this.remoteServices = remoteServices;
    }

    /**
     * List of remote services transfer objects of the datacenter
     * 
     * @return the remoteServices
     */
    public RemoteServicesDto getRemoteServices()
    {
        return remoteServices;
    }

    /**
     * Unique identifier of the datacenter shared with the remote services
     * 
     * @Output
     * @return The unique identifier of the datacenter
     */
    public String getUuid()
    {
        return uuid;
    }

    public void setUuid(final String uuid)
    {
        this.uuid = uuid;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }

}
