/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.infrastructure;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.transport.SingleResourceTransportDto;

/**
 * The dto used to retrieve only the id and name of the datacenter
 */
@XmlType(propOrder = {"idDatacenter", "name"})
@XmlRootElement(name = "datacenterlight")
public class DatacenterLightDto extends SingleResourceTransportDto implements Serializable
{

    private static final String TYPE = "application/vnd.abiquo.datacenterlight";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    private int idDatacenter;

    private String name;

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    public void setName(final String name)
    {
        this.name = name;
    }

    /**
     * Name of the datacenter
     * 
     * @return
     */
    public String getName()
    {
        return name;
    }

    public void setIdDatacenter(final int idDatacenter)
    {
        this.idDatacenter = idDatacenter;
    }

    /**
     * Identifier of the datacenter
     * 
     * @return
     */
    public int getIdDatacenter()
    {
        return idDatacenter;
    }

    public DatacenterLightDto()
    {

    }

    public DatacenterLightDto(final int id, final String name)
    {
        setIdDatacenter(id);
        setName(name);
    }
}
