/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * abiCloud  community version
 * cloud management application for hybrid clouds
 * Copyright (C) 2008-2010 - Soluciones Grid SL
 *
 * This application is free software; you can redistribute it and/or
 * modify it under the terms of the GNU LESSER GENERAL PUBLIC
 * LICENSE as published by the Free Software Foundation under
 * version 3 of the License
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * LESSER GENERAL PUBLIC LICENSE v.3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

package com.abiquo.server.core.infrastructure;

import java.io.Serializable;

import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.transport.SingleResourceTransportDto;

/**
 * Representation of a Datastore
 */
@XmlRootElement(name = "datastore")
@XmlType(propOrder = {"id", "name", "rootPath", "directory", "size", "usedSize", "enabled",
"datastoreUUID"})
public class DatastoreDto extends SingleResourceTransportDto implements Serializable
{
    private static final long serialVersionUID = 1L;

    private static final String TYPE = "application/vnd.abiquo.datastore";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    private Integer id;

    /**
     * Identifier of the datastore
     * 
     * @output
     */
    public Integer getId()
    {
        return id;
    }

    public void setId(final Integer id)
    {
        this.id = id;
    }

    private String name;

    /**
     * Name of the datastore
     */
    @NotNull
    public String getName()
    {
        return name;
    }

    public void setName(final String name)
    {
        this.name = name;
    }

    private String directory;

    /**
     * Direcotry of the datastore
     */
    public String getDirectory()
    {
        return directory;
    }

    public void setDirectory(final String directory)
    {
        this.directory = directory;
    }

    private String rootPath;

    /**
     * Path to the root of the datastore
     */
    @NotNull
    public String getRootPath()
    {
        return rootPath;
    }

    public void setRootPath(final String rootPath)
    {
        this.rootPath = rootPath;
    }

    private long size;

    /**
     * Size of the datastore
     */
    @NotNull
    public long getSize()
    {
        return size;
    }

    public void setSize(final long size)
    {
        this.size = size;
    }

    private long usedSize;

    /**
     * Used size of the datastore
     */
    @NotNull
    public long getUsedSize()
    {
        return usedSize;
    }

    public void setUsedSize(final long usedSize)
    {
        this.usedSize = usedSize;
    }

    private boolean enabled = true;

    /**
     * Indicates if the datastore is enabled to be used or not
     */
    @NotNull
    public boolean isEnabled()
    {
        return enabled;
    }

    public void setEnabled(final boolean enabled)
    {
        this.enabled = enabled;
    }

    private String datastoreUUID;

    public void setDatastoreUUID(final String datastoreUUID)
    {
        this.datastoreUUID = datastoreUUID;
    }

    /**
     * Unique identifier of the physical datastore
     */
    @NotNull
    public String getDatastoreUUID()
    {
        return datastoreUUID;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }
}
