/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.infrastructure;

import java.io.Serializable;

import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.transport.SingleResourceTransportDto;

@XmlRootElement(name = "machinesToCreate")
@XmlType(propOrder = {"ipFrom", "ipTo", "hypervisor", "user", "password", "port", "vSwitch"})
public class MachinesToCreateDto extends SingleResourceTransportDto implements Serializable
{
    private static final long serialVersionUID = 1682439124759672513L;

    private static final String TYPE = "application/vnd.abiquo.multiplemachines";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    private String ipFrom;

    private String ipTo;

    private String hypervisor;

    private String user;

    private String password;

    private Integer port;

    private String vSwitch;

    /**
     * Start of the IP interval of the machines to discover.
     */
    @NotNull
    public String getIpFrom()
    {
        return ipFrom;
    }

    public void setIpFrom(final String ipFrom)
    {
        this.ipFrom = ipFrom;
    }

    /**
     * End of the IP interval of the machines to discover.
     */
    @NotNull
    public String getIpTo()
    {
        return ipTo;
    }

    public void setIpTo(final String ipTo)
    {
        this.ipTo = ipTo;
    }

    /**
     * Value of the hypervisor type supported by abiquo.
     */
    @NotNull
    public String getHypervisor()
    {
        return hypervisor;
    }

    public void setHypervisor(final String hypervisor)
    {
        this.hypervisor = hypervisor;
    }

    /**
     * Name of the user for loggon into the hypervisor service.
     */
    @NotNull
    public String getUser()
    {
        return user;
    }

    public void setUser(final String user)
    {
        this.user = user;
    }

    /**
     * Password of the user for loggon into the hypervisor service.
     */
    @NotNull
    public String getPassword()
    {
        return password;
    }

    public void setPassword(final String password)
    {
        this.password = password;
    }

    /**
     * Connection port of the machines to discover.
     */
    @NotNull
    public Integer getPort()
    {
        return port;
    }

    public void setPort(final Integer port)
    {
        this.port = port;
    }

    /**
     * Virtual switch of the machines to discover
     */
    @NotNull
    public String getvSwitch()
    {
        return vSwitch;
    }

    public void setvSwitch(final String vSwitch)
    {
        this.vSwitch = vSwitch;
    }

    public MachinesToCreateDto()
    {

    }

    public MachinesToCreateDto(final String ipFrom, final String ipTo, final String hypervisor,
        final String user, final String password, final Integer port, final String vSwitch)
    {
        this.ipFrom = ipFrom;
        this.ipTo = ipTo;
        this.hypervisor = hypervisor;
        this.user = user;
        this.password = password;
        this.port = port;
        this.vSwitch = vSwitch;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }

}
