/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.infrastructure;

import java.io.Serializable;

import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.transport.SingleResourceTransportDto;

/**
 * The Class RackDto.
 */
@XmlRootElement(name = "rack")
@XmlType(propOrder = {"id", "haEnabled", "longDescription", "name", "nrsq", "shortDescription",
"vlanIdMax", "vlanIdMin", "vlanPerVdcReserved", "vlansIdAvoided"})
public class RackDto extends SingleResourceTransportDto implements Serializable
{
    private static final String TYPE = "application/vnd.abiquo.rack";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    /** The Constant serialVersionUID. */
    private static final long serialVersionUID = 1L;

    /** The id. */
    private Integer id;

    /** The long description. */
    private String name, shortDescription, longDescription;

    /** The nrsq. */
    private Integer vlanIdMin, vlanIdMax, vlanPerVdcReserved, nrsq;

    /** The vlans id avoided. */
    private String vlansIdAvoided;

    /** The ha enabled. */
    private boolean haEnabled = false;

    /**
     * Identifier of the entity.
     * 
     * @output
     * @return the id
     */
    public Integer getId()
    {
        return id;
    }

    /**
     * Sets the id.
     * 
     * @param id the new id
     */
    public void setId(final Integer id)
    {
        this.id = id;
    }

    /**
     * Name of the rack.
     * 
     * @return the name
     */
    @NotNull
    public String getName()
    {
        return name;
    }

    /**
     * Sets the name.
     * 
     * @param name the new name
     */
    public void setName(final String name)
    {
        this.name = name;
    }

    /**
     * Short description of the rack.
     * 
     * @return the short description
     */
    public String getShortDescription()
    {
        return shortDescription;
    }

    /**
     * Sets the short description.
     * 
     * @param description the new short description
     */
    public void setShortDescription(final String description)
    {
        this.shortDescription = description;
    }

    /**
     * Long description of the rack.
     * 
     * @return the long description
     */
    public String getLongDescription()
    {
        return longDescription;
    }

    /**
     * Sets the long description.
     * 
     * @param description the new long description
     */
    public void setLongDescription(final String description)
    {
        this.longDescription = description;
    }

    /**
     * Minimum value of the tag of the VLANs allowed in the rack.
     * 
     * @return the vlan id min
     */
    public Integer getVlanIdMin()
    {
        return vlanIdMin;
    }

    /**
     * Sets the vlan id min.
     * 
     * @param vlanIdMin the new vlan id min
     */
    public void setVlanIdMin(final Integer vlanIdMin)
    {
        this.vlanIdMin = vlanIdMin;
    }

    /**
     * Maximum value of the tag of the VLANs allowed in the rack.
     * 
     * @return the vlan id max
     */
    public Integer getVlanIdMax()
    {
        return vlanIdMax;
    }

    /**
     * Sets the vlan id max.
     * 
     * @param vlanIdMax the new vlan id max
     */
    public void setVlanIdMax(final Integer vlanIdMax)
    {
        this.vlanIdMax = vlanIdMax;
    }

    /**
     * Specify the percentatge of new virtual datacenters tolerance in allocation.
     * 
     * @return the nrsq
     */
    public Integer getNrsq()
    {
        return nrsq;
    }

    /**
     * Sets the nrsq.
     * 
     * @param nrsq the new nrsq
     */
    public void setNrsq(final Integer nrsq)
    {
        this.nrsq = nrsq;
    }

    /**
     * List of tags avoided in the VLANs allowed in the rack.
     * 
     * @return the vlans id avoided
     */
    public String getVlansIdAvoided()
    {
        return vlansIdAvoided;
    }

    /**
     * Sets the vlans id avoided.
     * 
     * @param vlansIdAvoided the new vlans id avoided
     */
    public void setVlansIdAvoided(final String vlansIdAvoided)
    {
        this.vlansIdAvoided = vlansIdAvoided;
    }

    /**
     * Deprecated field.
     * 
     * @output
     * @return the vlan per vdc reserved
     */
    public Integer getVlanPerVdcReserved()
    {
        return vlanPerVdcReserved;
    }

    /**
     * Sets the vlan per vdc reserved.
     * 
     * @param vlanPerVdcReserved the new vlan per vdc reserved
     */
    public void setVlanPerVdcReserved(final Integer vlanPerVdcReserved)
    {
        this.vlanPerVdcReserved = vlanPerVdcReserved;
    }

    /**
     * HA enabled in the rack.
     * 
     * @return true, if is ha enabled
     */
    public boolean isHaEnabled()
    {
        return haEnabled;
    }

    /**
     * Sets the ha enabled.
     * 
     * @param haEnabled the new ha enabled
     */
    public void setHaEnabled(final boolean haEnabled)
    {
        this.haEnabled = haEnabled;
    }

    /*
     * (non-Javadoc)
     * @see com.abiquo.model.transport.SingleResourceTransportDto#getMediaType()
     */
    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    /*
     * (non-Javadoc)
     * @see com.abiquo.model.transport.SingleResourceTransportDto#getBaseMediaType()
     */
    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }
}
