/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.infrastructure;

import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.enumerator.RemoteServiceType;
import com.abiquo.model.transport.SingleResourceTransportDto;
import com.abiquo.model.transport.error.ErrorsDto;

@XmlRootElement(name = "remoteService")
@XmlType(propOrder = {"id", "type", "uri", "status", "configurationErrors"})
public class RemoteServiceDto extends SingleResourceTransportDto
{
    private static final String TYPE = "application/vnd.abiquo.remoteservice";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    private Integer id;

    private String uri;

    private RemoteServiceType type;

    private int status;

    private ErrorsDto configurationErrors;

    /**
     * Identifier of the entity
     * 
     * @Output
     * @return Identifier of the entity
     */
    public Integer getId()
    {
        return id;
    }

    public void setId(final Integer id)
    {
        this.id = id;
    }

    /**
     * URI of the remote service
     * 
     * @return URI of the remote service
     */
    @NotNull
    public String getUri()
    {
        return uri;
    }

    public void setUri(final String uri)
    {
        this.uri = uri;
    }

    /**
     * Remote Service Type
     * 
     * @return Remote Service Type
     */
    @NotNull
    public RemoteServiceType getType()
    {
        return type;
    }

    public void setType(final RemoteServiceType type)
    {
        this.type = type;
    }

    /**
     * Current status of the remote service
     * 
     * @Output
     * @return Current status of the remote service
     */
    public int getStatus()
    {
        return status;
    }

    public void setStatus(final int status)
    {
        this.status = status;
    }

    /**
     * List of configuration errors
     * 
     * @Output
     * @return List of configuration errors
     */
    @XmlElement(name = "configurationErrors")
    public ErrorsDto getConfigurationErrors()
    {
        return configurationErrors;
    }

    public void setConfigurationErrors(final ErrorsDto configurationErrors)
    {
        this.configurationErrors = configurationErrors;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }
}
