/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.infrastructure.network;

import javax.xml.bind.annotation.XmlType;

/**
 * @author jdevesa
 */
@XmlType(propOrder = {"available", "quarantine"})
public abstract class AbstractInfrastructureIpDto extends AbstractIpDto
{
    private static final long serialVersionUID = 1L;

    private boolean available;

    private boolean quarantine;

    /**
     * If the IP is available to be used by a customer"
     */
    public boolean isAvailable()
    {
        return available;
    }

    /**
     * IP in quarantine
     */
    public boolean isQuarantine()
    {
        return quarantine;
    }

    public void setAvailable(final boolean available)
    {
        this.available = available;
    }

    public void setQuarantine(final boolean quarantine)
    {
        this.quarantine = quarantine;
    }

}
