/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.infrastructure.network;

import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.transport.SingleResourceTransportDto;

/**
 * @author jdevesa
 */
@XmlType(propOrder = {"id", "ip", "mac", "name", "networkName", "ipv6"})
public abstract class AbstractIpDto extends SingleResourceTransportDto
{
    private static final long serialVersionUID = 1L;

    private Integer id;

    private String ip;

    private String mac;

    private String name;

    private String networkName;

    private boolean ipv6;

    /**
     * Identifier of the entity
     * 
     * @output
     */
    public Integer getId()
    {
        return id;
    }

    /**
     * String that represents the IP address
     * 
     * @output
     * @return
     */
    public String getIp()
    {
        return ip;
    }

    /**
     * MAC address associated to the IP address
     * 
     * @output
     * @return
     */
    public String getMac()
    {
        return mac;
    }

    /**
     * Lease name of the entity. It will be used by the DHCP server to identify the IP-MAC static
     * rule
     * 
     * @output
     * @return
     */
    public String getName()
    {
        return name;
    }

    /**
     * Name of the network which the IP belongs to
     * 
     * @output
     * @return
     */
    public String getNetworkName()
    {
        return networkName;
    }

    public void setId(final Integer id)
    {
        this.id = id;
    }

    public void setIp(final String ip)
    {
        this.ip = ip;
    }

    public void setMac(final String mac)
    {
        this.mac = mac;
    }

    public void setName(final String name)
    {
        this.name = name;
    }

    public void setNetworkName(final String networkName)
    {
        this.networkName = networkName;
    }

    public boolean isIpv6()
    {
        return ipv6;
    }

    public void setIpv6(final boolean ipv6)
    {
        this.ipv6 = ipv6;
    }

}
