/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * 
 */
package com.abiquo.server.core.infrastructure.network;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.transport.SingleResourceTransportDto;

/**
 * @author <a href="mailto:serafin.sedano@abiquo.com">Serafin Sedano</a>
 */
@XmlRootElement(name = "networkconfiguration")
@XmlType(propOrder = {"id", "gateway", "primaryDNS", "secondaryDNS", "suffixDNS"})
public class NetworkConfigurationDto extends SingleResourceTransportDto
{

    private static final long serialVersionUID = -5522049430377114601L;

    private static final String TYPE = "application/vnd.abiquo.networkconfiguration";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    public NetworkConfigurationDto()
    {

    }

    private Integer id;

    private String gateway;

    private String primaryDNS;

    private String secondaryDNS;

    private String suffixDNS;

    /**
     * Identifier of the entity
     * 
     * @output
     * @return
     */
    public Integer getId()
    {
        return this.id;
    }

    public void setId(final Integer id)
    {
        this.id = id;
    }

    /**
     * Gateway of the network configuration
     * 
     * @output
     * @return
     */
    public String getGateway()
    {
        return gateway;
    }

    public void setGateway(final String gateway)
    {
        this.gateway = gateway;
    }

    /**
     * Primary DNS of the network configuration
     * 
     * @output
     * @return
     */
    public String getPrimaryDNS()
    {
        return primaryDNS;
    }

    public void setPrimaryDNS(final String primaryDNS)
    {
        this.primaryDNS = primaryDNS;
    }

    /**
     * Secondary DNS of the network configuration
     * 
     * @output
     */
    public String getSecondaryDNS()
    {
        return secondaryDNS;
    }

    public void setSecondaryDNS(final String secondaryDNS)
    {
        this.secondaryDNS = secondaryDNS;
    }

    /**
     * Suffix DNS of the network configuration
     * 
     * @output
     * @return
     */
    public String getSuffixDNS()
    {
        return suffixDNS;
    }

    public void setSuffixDNS(final String suffixDNS)
    {
        this.suffixDNS = suffixDNS;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }

}
