/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.infrastructure.network;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.rest.RESTLink;
import com.abiquo.model.transport.SingleResourceTransportDto;
import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * Represents a NIC entity into a target Hypervisor
 * 
 * @restlink <link rel='networkservicetype'
 *           href='http://example.com/api/admin/datacenter/{datacenterId}/networkservicetypes/{nstId
 *           } ' />
 */
@XmlRootElement(name = "networkinterfacedto")
@XmlType(propOrder = {"id", "name", "mac"})
public class NetworkInterfaceDto extends SingleResourceTransportDto
{
    private static final long serialVersionUID = 1L;

    private static final String TYPE = "application/vnd.abiquo.networkinterface";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    public static final String NETWORK_SERVICE_TYPE_REL = "networkservicetype";

    private Integer id;

    /**
     * Identifier of the entity
     * 
     * @output
     * @return
     */
    public Integer getId()
    {
        return id;
    }

    public void setId(final Integer id)
    {
        this.id = id;
    }

    private String name;

    /**
     * Name of the Network Interface in the target Hypervisor
     * 
     * @return
     */
    public String getName()
    {
        return name;
    }

    public void setName(final String name)
    {
        this.name = name;
    }

    private String mac;

    /**
     * MAC address of the Network Interface in the target Hypervisor
     * 
     * @return
     */
    public String getMac()
    {
        return mac;
    }

    public void setMac(final String mac)
    {
        this.mac = mac;
    }

    public void setNetworkServiceTypeLink(final String href)
    {
        RESTLink link = searchLink(NETWORK_SERVICE_TYPE_REL);
        if (link != null)
        {
            modifyLink(NETWORK_SERVICE_TYPE_REL, href);
        }
        else
        {
            link = new RESTLink(NETWORK_SERVICE_TYPE_REL, href);
            link.setType(NetworkServiceTypeDto.MEDIA_TYPE);
            addLink(link);
        }
    }

    @JsonIgnore
    public RESTLink getNetworkServiceTypeLink()
    {
        return searchLink(NETWORK_SERVICE_TYPE_REL);
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }

}
