/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.infrastructure.network;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.transport.SingleResourceTransportDto;

/**
 * The representation of {@link IpPoolManagementDto20} when we retrieve it from a VirtualMachine. It
 * represents a Virtual NIC in a Virtual Machine. It is a readOnly object.
 * 
 * @author jdevesa
 */
@XmlRootElement(name = "nic")
@XmlType(propOrder = {"id", "ip", "mac", "sequence", "tag"})
public class NicDto extends SingleResourceTransportDto
{

    private static final String TYPE = "application/vnd.abiquo.nic";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_20 = TYPE + "+" + XML + VERSION_PARAM + API_VERSION_20;

    public static final String REL_PREFIX = "nic";

    private static final long serialVersionUID = 3595021795100699222L;

    private Integer id;

    private String ip;

    private String mac;

    private Integer sequence;

    private Integer tag;

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }

    /**
     * Identifier of the entity
     * 
     * @output
     */
    public Integer getId()
    {
        return id;
    }

    /**
     * Ip address asociated to a NIC
     * 
     * @output
     */
    public String getIp()
    {
        return ip;
    }

    /**
     * MAC address of the NIC
     * 
     * @output
     */
    public String getMac()
    {
        return mac;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    /**
     * Sequence of the NIC inside its Virtual Machine
     * 
     * @output
     */
    public Integer getSequence()
    {
        return sequence;
    }

    public Integer getTag()
    {
        return tag;
    }

    public void setId(final Integer id)
    {
        this.id = id;
    }

    public void setIp(final String ip)
    {
        this.ip = ip;
    }

    public void setMac(final String mac)
    {
        this.mac = mac;
    }

    public void setSequence(final Integer sequence)
    {
        this.sequence = sequence;
    }

    public void setTag(final Integer tag)
    {
        this.tag = tag;
    }

}
