/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * 
 */
package com.abiquo.server.core.infrastructure.network;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

/**
 * Configuration network for a virtual machine.
 * 
 * @author jdevesa
 */
@XmlRootElement(name = "vmnetworkconfiguration")
@XmlType(propOrder = {"used"})
public class VMNetworkConfigurationDto extends NetworkConfigurationDto
{
    /**
     * Generated serial version id.
     */
    private static final long serialVersionUID = -3866622562676820662L;

    private static final String TYPE = "application/vnd.abiquo.virtualmachinenetworkconfiguration";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    public VMNetworkConfigurationDto()
    {

    }

    private Boolean used;

    /**
     * Check if this network configuration actually used by the virtual machine
     * 
     * @return
     */
    public Boolean getUsed()
    {
        return used;
    }

    public void setUsed(final Boolean used)
    {
        this.used = used;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }

}
