/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.infrastructure.storage;

import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.transport.SingleResourceTransportDto;

/**
 * 
 */
@XmlRootElement(name = "disk")
@XmlType(propOrder = {"id", "sequence", "sizeInMb"})
public class DiskManagementDto extends SingleResourceTransportDto
{
    public static final String TYPE = "application/vnd.abiquo.harddisk";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    public static final String REL_PREFIX = "disk";

    private static final long serialVersionUID = 1L;

    private Integer id;

    private Long sizeInMb;

    private Integer sequence;

    public void setSizeInMb(final Long sizeInMb)
    {
        this.sizeInMb = sizeInMb;
    }

    /**
     * Disk size in MegaBytes
     * 
     * @return
     */
    @NotNull
    public Long getSizeInMb()
    {
        return this.sizeInMb;
    }

    public void setSequence(final Integer sequence)
    {
        this.sequence = sequence;
    }

    /**
     * Sequence number of the disk into a virtual machine
     * 
     * @return
     */
    public Integer getSequence()
    {
        return sequence;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }

    public Integer getId()
    {
        return id;
    }

    public void setId(final Integer id)
    {
        this.id = id;
    }
}
